/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.shaded.org.quartz.ee.jta;

import org.openksavi.sponge.shaded.org.quartz.ExecuteInJTATransaction;
import org.openksavi.sponge.shaded.org.quartz.Scheduler;
import org.openksavi.sponge.shaded.org.quartz.SchedulerConfigException;
import org.openksavi.sponge.shaded.org.quartz.SchedulerException;
import org.openksavi.sponge.shaded.org.quartz.core.JobRunShell;
import org.openksavi.sponge.shaded.org.quartz.core.JobRunShellFactory;
import org.openksavi.sponge.shaded.org.quartz.ee.jta.JTAJobRunShell;
import org.openksavi.sponge.shaded.org.quartz.spi.TriggerFiredBundle;
import org.openksavi.sponge.shaded.org.quartz.utils.ClassUtils;

public class JTAAnnotationAwareJobRunShellFactory
implements JobRunShellFactory {
    private Scheduler scheduler;

    @Override
    public void initialize(Scheduler sched) throws SchedulerConfigException {
        this.scheduler = sched;
    }

    @Override
    public JobRunShell createJobRunShell(TriggerFiredBundle bundle) throws SchedulerException {
        ExecuteInJTATransaction jtaAnnotation = ClassUtils.getAnnotation(bundle.getJobDetail().getJobClass(), ExecuteInJTATransaction.class);
        if (jtaAnnotation == null) {
            return new JobRunShell(this.scheduler, bundle);
        }
        int timeout = jtaAnnotation.timeout();
        if (timeout >= 0) {
            return new JTAJobRunShell(this.scheduler, bundle, timeout);
        }
        return new JTAJobRunShell(this.scheduler, bundle);
    }
}

