/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.shaded.org.terracotta.quartz.wrappers;

import java.io.Serializable;
import java.util.Date;
import org.openksavi.sponge.shaded.org.quartz.Calendar;
import org.openksavi.sponge.shaded.org.quartz.JobKey;
import org.openksavi.sponge.shaded.org.quartz.TriggerKey;
import org.openksavi.sponge.shaded.org.quartz.spi.OperableTrigger;
import org.openksavi.sponge.shaded.org.terracotta.quartz.wrappers.TriggerFacade;

public class TriggerWrapper
implements Serializable {
    private final boolean jobDisallowsConcurrence;
    private volatile String lastTerracotaClientId = null;
    private volatile TriggerState state = TriggerState.WAITING;
    protected final OperableTrigger trigger;

    protected TriggerWrapper(OperableTrigger trigger, boolean jobDisallowsConcurrence) {
        this.trigger = trigger;
        this.jobDisallowsConcurrence = jobDisallowsConcurrence;
    }

    public boolean jobDisallowsConcurrence() {
        return this.jobDisallowsConcurrence;
    }

    public String getLastTerracotaClientId() {
        return this.lastTerracotaClientId;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( " + (Object)((Object)this.state) + ", lastTC=" + this.lastTerracotaClientId + ", " + this.trigger + ")";
    }

    public TriggerKey getKey() {
        return this.trigger.getKey();
    }

    public JobKey getJobKey() {
        return this.trigger.getJobKey();
    }

    public void setState(TriggerState state, String terracottaId, TriggerFacade triggerFacade) {
        if (terracottaId == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.lastTerracotaClientId = terracottaId;
        this.rePut(triggerFacade);
    }

    public TriggerState getState() {
        return this.state;
    }

    public Date getNextFireTime() {
        return this.trigger.getNextFireTime();
    }

    public int getPriority() {
        return this.trigger.getPriority();
    }

    public boolean mayFireAgain() {
        return this.trigger.mayFireAgain();
    }

    public OperableTrigger getTriggerClone() {
        return (OperableTrigger)this.trigger.clone();
    }

    public void updateWithNewCalendar(Calendar cal, long misfireThreshold, TriggerFacade triggerFacade) {
        this.trigger.updateWithNewCalendar(cal, misfireThreshold);
        this.rePut(triggerFacade);
    }

    public String getCalendarName() {
        return this.trigger.getCalendarName();
    }

    public int getMisfireInstruction() {
        return this.trigger.getMisfireInstruction();
    }

    public void updateAfterMisfire(Calendar cal, TriggerFacade triggerFacade) {
        this.trigger.updateAfterMisfire(cal);
        this.rePut(triggerFacade);
    }

    public void setFireInstanceId(String firedInstanceId, TriggerFacade triggerFacade) {
        this.trigger.setFireInstanceId(firedInstanceId);
        this.rePut(triggerFacade);
    }

    public void triggered(Calendar cal, TriggerFacade triggerFacade) {
        this.trigger.triggered(cal);
        this.rePut(triggerFacade);
    }

    private void rePut(TriggerFacade triggerFacade) {
        triggerFacade.put(this.trigger.getKey(), this);
    }

    public boolean isInstanceof(Class clazz) {
        return clazz.isInstance(this.trigger);
    }

    public static enum TriggerState {
        WAITING,
        ACQUIRED,
        COMPLETE,
        PAUSED,
        BLOCKED,
        PAUSED_BLOCKED,
        ERROR;

    }
}

