/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.openksavi.sponge.EventSetProcessor;
import org.openksavi.sponge.EventSetProcessorAdapter;
import org.openksavi.sponge.EventSetProcessorAdapterGroup;
import org.openksavi.sponge.EventSetProcessorDefinition;
import org.openksavi.sponge.EventSetProcessorState;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorDefinition;
import org.openksavi.sponge.core.BaseEventProcessorAdapter;
import org.openksavi.sponge.core.BaseEventSetProcessorAdapter;
import org.openksavi.sponge.core.BaseEventSetProcessorDefinition;
import org.openksavi.sponge.core.event.DurationControlEvent;
import org.openksavi.sponge.core.rule.BaseRuleAdapter;
import org.openksavi.sponge.core.rule.BaseRuleAdapterGroup;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.processing.EventSetProcessorMainProcessingUnitHandler;
import org.openksavi.sponge.event.ControlEvent;
import org.openksavi.sponge.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEventSetProcessorAdapterGroup<T extends EventSetProcessorAdapter>
extends BaseEventProcessorAdapter
implements EventSetProcessorAdapterGroup<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseEventSetProcessorAdapterGroup.class);
    private List<T> eventSetProcessorAdapters = new CopyOnWriteArrayList<T>();
    private EventSetProcessorMainProcessingUnitHandler<EventSetProcessorAdapterGroup<T>, T> handler;
    private Lock lock = new ReentrantLock(true);
    private BaseEventSetProcessorAdapter templateAdapter;

    protected BaseEventSetProcessorAdapterGroup(BaseEventSetProcessorAdapter templateAdapter, EventSetProcessorMainProcessingUnitHandler<EventSetProcessorAdapterGroup<T>, T> handler) {
        super(templateAdapter.getDefinition());
        this.handler = handler;
        this.templateAdapter = templateAdapter;
    }

    @Override
    public BaseEventSetProcessorDefinition getDefinition() {
        return (BaseEventSetProcessorDefinition)super.getDefinition();
    }

    public List<T> getEventSetProcessorAdapters() {
        return this.eventSetProcessorAdapters;
    }

    protected abstract T createNewEventSetProcessorAdapter();

    protected void tryAddNewEventSetProcessor(Event event) {
        String name = this.getDefinition().getName();
        try {
            if (!this.getTemplateAdapter().isCandidateForFirstEvent(event)) {
                return;
            }
            T adapter = this.createNewEventSetProcessorAdapter();
            EventSetProcessor eventSetProcessor = (EventSetProcessor)this.getKnowledgeBase().getEngineOperations().getEngine().getProcessorManager().createProcessorInstance((ProcessorDefinition)this.getDefinition(), EventSetProcessor.class);
            adapter.setProcessor((Processor)eventSetProcessor);
            adapter.setGroup((EventSetProcessorAdapterGroup)this);
            if (!adapter.acceptAsFirst(event)) {
                return;
            }
            adapter.getProcessor().onInit();
            this.eventSetProcessorAdapters.add(adapter);
            this.handler.addDuration(adapter);
            adapter.setState(EventSetProcessorState.RUNNING);
            logger.debug("{} - New instance, hash: {}, event: {}", new Object[]{adapter.getName(), adapter.hashCode(), event});
        }
        catch (Exception e) {
            throw SpongeUtils.wrapException(name, e);
        }
    }

    public void removeDuration(T adapter) {
        this.handler.removeDuration(adapter);
    }

    protected void removeFinishedEventSetProcessors() {
        Predicate<EventSetProcessorAdapter> filter = adapter -> adapter.getState() == EventSetProcessorState.FINISHED;
        this.eventSetProcessorAdapters.stream().filter(filter).forEach(adapter -> this.handler.removeDuration(adapter));
        this.eventSetProcessorAdapters.removeIf(filter);
    }

    public abstract boolean needNewInstance(Event var1);

    protected boolean processControlEvent(Event event) {
        if (!(event instanceof ControlEvent)) {
            return false;
        }
        if (event instanceof DurationControlEvent) {
            this.durationOccurred(((DurationControlEvent)event).getEventSetProcessorAdapter());
        }
        return true;
    }

    public void processEvent(Event event) {
        this.lock.lock();
        try {
            if (this.processControlEvent(event)) {
                return;
            }
            logger.debug("Processing event: {}", (Object)event);
            if (this.needNewInstance(event)) {
                this.tryAddNewEventSetProcessor(event);
            }
            this.logEventTree("before");
            this.handler.processEventForEventSetProcessorAdapters((EventSetProcessorDefinition)this.getDefinition(), this.eventSetProcessorAdapters, event);
            this.logEventTree("after");
            this.removeFinishedEventSetProcessors();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.eventSetProcessorAdapters.forEach(adapter -> adapter.clear());
            this.eventSetProcessorAdapters.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void durationOccurred(T adapter) {
        this.lock.lock();
        try {
            if (adapter.getState() == EventSetProcessorState.RUNNING) {
                adapter.durationOccurred();
            }
            this.eventSetProcessorAdapters.remove(adapter);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void validate() {
    }

    private void logEventTree(String label) {
        if (logger.isDebugEnabled() && this instanceof BaseRuleAdapterGroup) {
            this.eventSetProcessorAdapters.forEach(adapter -> logger.debug("({}/{}): Event tree " + label + ": {}", new Object[]{adapter.getName(), adapter.hashCode(), ((BaseRuleAdapter)adapter).getEventTree()}));
        }
    }

    public BaseEventSetProcessorAdapter getTemplateAdapter() {
        return this.templateAdapter;
    }
}

