/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.engine.ActionManager;
import org.openksavi.sponge.engine.Engine;

public class DefaultActionManager
extends BaseEngineModule
implements ActionManager {
    private Map<String, ActionAdapter> registeredActions = Collections.synchronizedMap(new LinkedHashMap());

    public DefaultActionManager(Engine engine) {
        super("ActionManager", engine);
    }

    public void addAction(ActionAdapter actionAdapter) {
        Validate.notNull((Object)actionAdapter, (String)"addAction called with null actionAdapter.", (Object[])new Object[0]);
        this.registeredActions.put(actionAdapter.getName(), actionAdapter);
    }

    public void removeAction(String actionName) {
        Validate.notNull((Object)actionName, (String)"removeAction called with null action name.", (Object[])new Object[0]);
        this.registeredActions.remove(actionName);
    }

    public Object callAction(String actionName, Object ... args) {
        ActionAdapter action = this.registeredActions.get(actionName);
        if (action == null) {
            throw new SpongeException("Action " + actionName + " is not registered");
        }
        return ((Action)action.getProcessor()).onCall(args);
    }

    public Map<String, ActionAdapter> getRegisteredActionAdapterMap() {
        return this.registeredActions;
    }

    public boolean existsAction(String name) {
        return this.registeredActions.containsKey(name);
    }
}

