/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.DefaultProcessableThreadPool;
import org.openksavi.sponge.core.engine.DefaultThreadPool;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.ProcessableThreadPool;
import org.openksavi.sponge.engine.ThreadPool;
import org.openksavi.sponge.engine.ThreadPoolManager;
import org.openksavi.sponge.engine.processing.FilterProcessingUnit;
import org.openksavi.sponge.engine.processing.MainProcessingUnit;
import org.openksavi.sponge.util.Processable;

public class DefaultThreadPoolManager
extends BaseEngineModule
implements ThreadPoolManager {
    public DefaultThreadPoolManager(Engine engine) {
        super("ThreadPoolManager", engine);
    }

    public ProcessableThreadPool createFilterProcessingUnitListenerThreadPool(FilterProcessingUnit filterProcessingUnit) {
        int threadCount = filterProcessingUnit.supportsConcurrentListenerThreadPool() ? this.getEngine().getDefaultParameters().getProcessingUnitConcurrentListenerThreadCount() : 1;
        return new DefaultProcessableThreadPool(this.createFixedExecutor(filterProcessingUnit, threadCount), (Processable)filterProcessingUnit);
    }

    public ProcessableThreadPool createMainProcessingUnitListenerThreadPool(MainProcessingUnit mainProcessingUnit) {
        int threadCount = mainProcessingUnit.supportsConcurrentListenerThreadPool() ? this.getEngine().getDefaultParameters().getProcessingUnitConcurrentListenerThreadCount() : 1;
        return new DefaultProcessableThreadPool(this.createFixedExecutor(mainProcessingUnit, threadCount), (Processable)mainProcessingUnit);
    }

    public ProcessableThreadPool createMainProcessingUnitDecomposedQueueThreadPool(Processable processable) {
        return new DefaultProcessableThreadPool(this.createFixedExecutor(processable, 1), processable);
    }

    public ThreadPool createMainProcessingUnitWorkerThreadPool() {
        String name = "MainProcessingUnit.Worker";
        int workers = this.getEngine().getConfigurationManager().getMainProcessingUnitThreadCount();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(workers, workers, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.getEngine().getDefaultParameters().getMainProcessingUnitWorkerExecutorQueueSize()), (ThreadFactory)this.createThreadFactory(name));
        return new DefaultThreadPool(name, executor);
    }

    public ThreadPool createMainProcessingUnitAsyncEventSetProcessorThreadPool() {
        String name = "MainProcessingUnit.AsyncEventSet";
        int maxThreadCount = this.getEngine().getConfigurationManager().getAsyncEventSetProcessorExecutorThreadCount();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(SpongeUtils.calculateInitialDynamicThreadPoolSize(this.getEngine(), maxThreadCount), maxThreadCount, this.getEngine().getDefaultParameters().getDynamicThreadPoolKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)this.createThreadFactory(name));
        return new DefaultThreadPool(name, executor);
    }

    public ThreadPool createMainProcessingUnitEventSetProcessorDurationThreadPool() {
        String name = "MainProcessingUnit.Duration";
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(this.getEngine().getConfigurationManager().getDurationThreadCount(), (ThreadFactory)this.createThreadFactory(name));
        return new DefaultThreadPool(name, executor);
    }

    protected BasicThreadFactory createThreadFactory(Object named) {
        return new BasicThreadFactory.Builder().namingPattern(named.toString() + "-%d").build();
    }

    public ExecutorService createFixedExecutor(Object named, int threadCount) {
        return Executors.newFixedThreadPool(threadCount, (ThreadFactory)this.createThreadFactory(named));
    }

    public void startupProcessableThreadPool(ProcessableThreadPool threadPool) {
        threadPool.getFutures().add(threadPool.getExecutor().submit(threadPool.getProcessable().createWorker()));
    }

    public void shutdownThreadPool(ThreadPool threadPool) {
        ExecutorService executor = threadPool.getExecutor();
        if (executor == null) {
            return;
        }
        try {
            SpongeUtils.shutdownExecutorService(this.getEngine(), threadPool.getName(), executor);
        }
        finally {
            threadPool.clear();
        }
    }

    public static class WaitRejectedExecutionHandlerPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(runnable);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException("Interrupted", e);
                }
            } else {
                throw new RejectedExecutionException("Executor has been shut down");
            }
        }
    }
}

