/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openksavi.sponge.config.PropertyEntry;
import org.openksavi.sponge.core.engine.BaseEngine;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.GenericPropertyEntry;
import org.openksavi.sponge.core.kb.DefaultScriptKnowledgeBase;
import org.openksavi.sponge.core.kb.FileKnowledgeBaseScript;
import org.openksavi.sponge.engine.EngineParameters;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.openksavi.sponge.kb.KnowledgeBaseScript;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.spi.EngineModuleProvider;
import org.openksavi.sponge.spi.EventQueueProvider;
import org.openksavi.sponge.spi.KnowledgeBaseInterpreterFactoryProvider;
import org.openksavi.sponge.spi.ProcessingUnitProvider;

public class EngineBuilder<T extends BaseEngine> {
    protected T engine;
    protected List<Plugin> plugins = new ArrayList<Plugin>();
    protected List<KnowledgeBase> knowledgeBases = new ArrayList<KnowledgeBase>();
    protected Map<String, PropertyEntry> propertyEntries = new LinkedHashMap<String, PropertyEntry>();

    public EngineBuilder(T engine) {
        this.engine = engine;
    }

    public EngineBuilder<T> name(String name) {
        ((BaseEngineModule)this.engine).setName(name);
        return this;
    }

    public EngineBuilder<T> moduleProvider(EngineModuleProvider moduleProvider) {
        ((BaseEngine)this.engine).setModuleProvider(moduleProvider);
        return this;
    }

    public EngineBuilder<T> knowledgeBaseInterpreterFactoryProviders(List<KnowledgeBaseInterpreterFactoryProvider> knowledgeBaseInterpreterFactoryProviders) {
        ((BaseEngine)this.engine).setKnowledgeBaseInterpreterFactoryProviders(knowledgeBaseInterpreterFactoryProviders);
        return this;
    }

    public EngineBuilder<T> eventQueueProvider(EventQueueProvider eventQueueProvider) {
        ((BaseEngine)this.engine).setEventQueueProvider(eventQueueProvider);
        return this;
    }

    public EngineBuilder<T> processingUnitProvider(ProcessingUnitProvider processingUnitProvider) {
        ((BaseEngine)this.engine).setProcessingUnitProvider(processingUnitProvider);
        return this;
    }

    public EngineBuilder<T> knowledgeBaseFileProvider(KnowledgeBaseFileProvider knowledgeBaseFileProvider) {
        ((BaseEngine)this.engine).setKnowledgeBaseFileProvider(knowledgeBaseFileProvider);
        return this;
    }

    public EngineBuilder<T> config(String configFilename) {
        ((BaseEngine)this.engine).setConfigurationFilename(configFilename);
        return this;
    }

    public EngineBuilder<T> property(String name, Object value, boolean variable, boolean system) {
        this.propertyEntries.put(name, new GenericPropertyEntry(value, variable, system));
        return this;
    }

    public EngineBuilder<T> property(String name, Object value) {
        return this.property(name, value, false, false);
    }

    public EngineBuilder<T> systemProperty(String name, Object value) {
        return this.property(name, value, false, true);
    }

    public EngineBuilder<T> variableProperty(String name, Object value) {
        return this.property(name, value, true, false);
    }

    public EngineBuilder<T> properties(Map<String, Object> simpleProperties) {
        simpleProperties.forEach((name, value) -> this.property((String)name, value));
        return this;
    }

    public EngineBuilder<T> systemProperties(Map<String, String> systemProperties) {
        systemProperties.forEach((name, value) -> this.systemProperty((String)name, value));
        return this;
    }

    public EngineBuilder<T> variableProperties(Map<String, String> variableProperties) {
        variableProperties.forEach((name, value) -> this.variableProperty((String)name, value));
        return this;
    }

    public EngineBuilder<T> plugin(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public EngineBuilder<T> plugins(Plugin ... plugins) {
        Stream.of(plugins).forEachOrdered(plugin -> this.plugin((Plugin)plugin));
        return this;
    }

    public EngineBuilder<T> knowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBases.add(knowledgeBase);
        return this;
    }

    public EngineBuilder<T> knowledgeBase(String name, KnowledgeBaseType type, String ... files) {
        return this.knowledgeBase(name, type, Stream.of(files).map(file -> new FileKnowledgeBaseScript((String)file)).collect(Collectors.toList()));
    }

    public EngineBuilder<T> knowledgeBase(String name, String ... files) {
        return this.knowledgeBase(name, Stream.of(files).map(file -> new FileKnowledgeBaseScript((String)file)).collect(Collectors.toList()));
    }

    public EngineBuilder<T> knowledgeBase(String name, KnowledgeBaseScript ... scripts) {
        return this.knowledgeBase(name, null, Stream.of(scripts).collect(Collectors.toList()));
    }

    public EngineBuilder<T> knowledgeBase(String name, List<KnowledgeBaseScript> scripts) {
        return this.knowledgeBase(name, null, scripts);
    }

    public EngineBuilder<T> knowledgeBase(String name, KnowledgeBaseType type, List<KnowledgeBaseScript> scripts) {
        DefaultScriptKnowledgeBase knowledgeBase = new DefaultScriptKnowledgeBase(name, type);
        scripts.forEach(script -> knowledgeBase.addScript((KnowledgeBaseScript)script));
        this.knowledgeBases.add(knowledgeBase);
        return this;
    }

    public EngineBuilder<T> exceptionHandler(ExceptionHandler exceptionHandler) {
        ((BaseEngine)this.engine).setExceptionHandler(exceptionHandler);
        return this;
    }

    public EngineParameters getEngineDefaultParameters() {
        return ((BaseEngine)this.engine).getDefaultParameters();
    }

    public T build() {
        ((BaseEngine)this.engine).init();
        if (this.propertyEntries != null) {
            ((BaseEngine)this.engine).getConfigurationManager().setPropertyEntries(this.propertyEntries);
        }
        this.plugins.forEach(plugin -> ((BaseEngine)this.engine).getPluginManager().addPlugin(plugin));
        this.knowledgeBases.forEach(knowledgeBase -> ((BaseEngine)this.engine).getKnowledgeBaseManager().addKnowledgeBase(knowledgeBase));
        return this.engine;
    }

    public String getDescription() {
        return ((BaseEngine)this.engine).getDescription();
    }
}

