/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.stream.Collectors;
import org.openksavi.sponge.engine.ExceptionContext;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.openksavi.sponge.engine.WrappedException;
import org.openksavi.sponge.shaded.com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExceptionHandler
implements ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoggingExceptionHandler.class);

    public void handleException(Throwable exception, ExceptionContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error" + (context.getSourceName() != null ? " in " + context.getSourceName() : "") + ":\n");
        sb.append(Throwables.getCausalChain(exception instanceof WrappedException ? exception.getCause() : exception).stream().map(e -> " * " + e.toString()).collect(Collectors.joining("\n")));
        sb.append("\nStack trace:\n" + Throwables.getStackTraceAsString(exception));
        logger.error(sb.toString());
    }
}

