/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.processing;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openksavi.sponge.EventSetProcessorAdapter;
import org.openksavi.sponge.EventSetProcessorAdapterGroup;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.core.engine.processing.BaseMainProcessingUnit;
import org.openksavi.sponge.core.engine.processing.BaseMainProcessingUnitHandler;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.ThreadPool;
import org.openksavi.sponge.engine.processing.EventSetProcessorMainProcessingUnitHandler;
import org.openksavi.sponge.event.Event;

public abstract class BaseEventSetProcessorMainProcessingUnitHandler<G extends EventSetProcessorAdapterGroup<T>, T extends EventSetProcessorAdapter<?>>
extends BaseMainProcessingUnitHandler
implements EventSetProcessorMainProcessingUnitHandler<G, T> {
    private ThreadPool durationThreadPool;
    private Map<T, EventSetProcessorDurationTask<T>> durationTasks = Collections.synchronizedMap(new WeakHashMap());
    private Lock lock = new ReentrantLock(true);

    protected BaseEventSetProcessorMainProcessingUnitHandler(ProcessorType type, BaseMainProcessingUnit processingUnit) {
        super(type, processingUnit);
    }

    public void startup() {
        this.lock.lock();
        try {
            this.durationThreadPool = this.getProcessingUnit().getEngine().getThreadPoolManager().createMainProcessingUnitEventSetProcessorDurationThreadPool();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        this.lock.lock();
        try {
            if (this.durationThreadPool != null) {
                this.durationTasks.values().stream().filter(task -> task.getFuture() != null).forEach(task -> task.getFuture().cancel(false));
                this.getProcessingUnit().getEngine().getThreadPoolManager().shutdownThreadPool(this.durationThreadPool);
                this.durationThreadPool = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void processEvent(ProcessorAdapter<?> adapter, Event event) {
        ((EventSetProcessorAdapterGroup)adapter).processEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDuration(T adapter) {
        this.lock.lock();
        try {
            if (adapter.hasDuration()) {
                EventSetProcessorDurationTask<T> task = new EventSetProcessorDurationTask<T>(adapter);
                this.durationTasks.put(adapter, task);
                ScheduledFuture<?> future = ((ScheduledExecutorService)this.durationThreadPool.getExecutor()).schedule(task, adapter.getDuration().toMillis(), TimeUnit.MILLISECONDS);
                task.setFuture(future);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDuration(T adapter) {
        this.lock.lock();
        try {
            EventSetProcessorDurationTask<T> task;
            if (adapter.hasDuration() && (task = this.durationTasks.get(adapter)) != null) {
                task.getFuture().cancel(true);
                this.durationTasks.remove(adapter);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeDurations(G adapterGroup) {
        this.lock.lock();
        try {
            adapterGroup.getEventSetProcessorAdapters().forEach(adapter -> this.removeDuration(adapter));
        }
        finally {
            this.lock.unlock();
        }
    }

    public ThreadPool getAsyncEventSetProcessorThreadPool() {
        return this.getProcessingUnit().getAsyncEventSetProcessorThreadPool();
    }

    public static class EventSetProcessorDurationTask<T extends EventSetProcessorAdapter<?>>
    implements Runnable {
        private T adapter;
        private ScheduledFuture<?> future;

        public EventSetProcessorDurationTask(T adapter) {
            this.adapter = adapter;
        }

        public T getAdapter() {
            return this.adapter;
        }

        public void setAdapter(T adapter) {
            this.adapter = adapter;
        }

        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        @Override
        public void run() {
            Engine engine = this.adapter.getKnowledgeBase().getEngineOperations().getEngine();
            try {
                engine.getEventSetProcessorDurationStrategy().durationOccurred(this.adapter);
            }
            catch (Throwable e) {
                engine.handleError(this.adapter, e);
            }
        }
    }
}

