/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.processing;

import java.util.concurrent.atomic.AtomicReference;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.core.engine.processing.BaseProcessingUnit;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.ProcessableThreadPool;
import org.openksavi.sponge.engine.ThreadPool;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.engine.processing.FilterProcessingUnit;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.filter.Filter;
import org.openksavi.sponge.filter.FilterAdapter;
import org.openksavi.sponge.util.Processable;

public class DefaultFilterProcessingUnit
extends BaseProcessingUnit<FilterAdapter>
implements FilterProcessingUnit {
    protected ProcessableThreadPool filterProcessingUnitListenerThreadPoolEntry;

    public DefaultFilterProcessingUnit(String name, Engine engine, EventQueue inQueue, EventQueue outQueue) {
        super(name, engine, inQueue, outQueue);
    }

    @Override
    public void doStartup() {
        this.filterProcessingUnitListenerThreadPoolEntry = this.getThreadPoolManager().createFilterProcessingUnitListenerThreadPool((FilterProcessingUnit)this);
        this.getThreadPoolManager().startupProcessableThreadPool(this.filterProcessingUnitListenerThreadPoolEntry);
    }

    @Override
    public void doShutdown() {
        this.getThreadPoolManager().shutdownThreadPool((ThreadPool)this.filterProcessingUnitListenerThreadPoolEntry);
    }

    public Runnable createWorker() {
        return new FilterLoopWorker((Processable)this);
    }

    public boolean processEvent(Event event) {
        for (AtomicReference filterContextR : this.getEventProcessors(event.getName())) {
            FilterAdapter filterContext = (FilterAdapter)filterContextR.get();
            try {
                if (this.runFilter(filterContext, event)) continue;
                return false;
            }
            catch (Exception e) {
                this.getEngine().handleError((ProcessorAdapter)filterContext, (Throwable)e);
            }
        }
        return true;
    }

    protected boolean runFilter(FilterAdapter filterContext, Event event) {
        return ((Filter)filterContext.getProcessor()).onAccept(event);
    }

    public boolean supportsConcurrentListenerThreadPool() {
        return false;
    }

    protected class FilterLoopWorker
    extends BaseProcessingUnit.EventLoopWorker {
        public FilterLoopWorker(Processable processable) {
            super(processable);
        }

        @Override
        public boolean shouldContinueLoop() {
            return DefaultFilterProcessingUnit.this.isNewOrStartingOrRunning() && !Thread.currentThread().isInterrupted();
        }

        @Override
        public boolean processEvent(Event event) throws InterruptedException {
            return DefaultFilterProcessingUnit.this.processEvent(event);
        }
    }
}

