/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.event;

import java.time.Duration;
import java.time.Instant;
import org.openksavi.sponge.EngineOperations;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.event.EventDefinition;
import org.openksavi.sponge.event.EventDefinitionModifier;
import org.openksavi.sponge.event.EventSchedulerEntry;

public class DefaultEventDefinition
implements EventDefinition {
    private EngineOperations engineOperations;
    private Event event;

    public DefaultEventDefinition(EngineOperations engineOperations, String name, EventClonePolicy clonePolicy) {
        this.engineOperations = engineOperations;
        this.event = this.engineOperations.makeEvent(name, clonePolicy);
    }

    public DefaultEventDefinition(EngineOperations engineOperations, Event event) {
        this.engineOperations = engineOperations;
        this.event = event;
    }

    public DefaultEventDefinition set(String name, Object value) {
        this.event.set(name, value);
        return this;
    }

    public DefaultEventDefinition modify(EventDefinitionModifier modifier) {
        modifier.modify(this.event);
        return this;
    }

    public Event send() {
        return this.engineOperations.send(this.event);
    }

    public EventSchedulerEntry sendAfter(long delay) {
        return this.engineOperations.sendAfter(this.event, delay);
    }

    public EventSchedulerEntry sendAfter(Duration delay) {
        return this.sendAfter(delay.toMillis());
    }

    public EventSchedulerEntry sendAfter(long delay, long interval) {
        return this.engineOperations.sendAfter(this.event, delay, interval);
    }

    public EventSchedulerEntry sendAfter(Duration delay, Duration interval) {
        return this.sendAfter(delay.toMillis(), interval.toMillis());
    }

    public EventSchedulerEntry sendAt(long milliseconds) {
        return this.engineOperations.sendAt(this.event, milliseconds);
    }

    public EventSchedulerEntry sendAt(Instant instant) {
        return this.sendAt(instant.toEpochMilli());
    }

    public EventSchedulerEntry sendAt(long milliseconds, long interval) {
        return this.engineOperations.sendAt(this.event, milliseconds, interval);
    }

    public EventSchedulerEntry sendAt(Instant instant, Duration interval) {
        return this.sendAt(instant.toEpochMilli(), interval.toMillis());
    }

    public EventSchedulerEntry sendAt(String crontabSpec) {
        return this.engineOperations.sendAt(this.event, crontabSpec);
    }

    public Event make() {
        return this.event;
    }
}

