/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.BaseRuleAdapter;
import org.openksavi.sponge.core.rule.RuleAdapterRuntime;
import org.openksavi.sponge.core.util.Tree;
import org.openksavi.sponge.core.util.TreeNode;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRuleAdapterRuntime
implements RuleAdapterRuntime {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRuleAdapterRuntime.class);
    protected BaseRuleAdapter adapter;
    protected Tree<RuleAdapterRuntime.NodeValue> eventTree = new Tree();
    protected transient Map<String, Event> eventAliasMap = new LinkedHashMap<String, Event>();

    public AbstractRuleAdapterRuntime(BaseRuleAdapter adapter) {
        this.adapter = adapter;
    }

    protected boolean checkConditions(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        List<EventCondition> conditions = this.adapter.getConditions(this.adapter.getEventAlias(this.getEventIndex(node)));
        if (conditions == null) {
            return true;
        }
        this.prepareEventAliasMap(node);
        for (EventCondition condition : conditions) {
            if (condition.condition((Rule)this.adapter.getProcessor(), node.getValue().getEvent())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptAsFirst(Event event) {
        TreeNode<RuleAdapterRuntime.NodeValue> newNode = new TreeNode<RuleAdapterRuntime.NodeValue>(new RuleAdapterRuntime.NodeValue(event));
        this.eventTree.setRoot(newNode);
        try {
            boolean bl = this.shouldAddToEventTreeForFlaModes(newNode, event);
            return bl;
        }
        finally {
            this.eventTree.setRoot(null);
        }
    }

    @Override
    public void onEvent(Event event) {
        if (!this.adapter.isRunning()) {
            return;
        }
        this.buildEventTree(this.eventTree.getRoot(), event);
        if (this.eventTree.isEmpty()) {
            this.adapter.finish();
        } else if (this.shouldRunRule() && this.runRule()) {
            this.adapter.finish();
        }
    }

    protected abstract int getEventIndex(TreeNode<RuleAdapterRuntime.NodeValue> var1);

    protected abstract boolean shouldRunRule();

    protected abstract boolean shouldAddToEventTreeForFlaModes(TreeNode<RuleAdapterRuntime.NodeValue> var1, Event var2);

    protected abstract int getExpectedEventIndex(TreeNode<RuleAdapterRuntime.NodeValue> var1, Event var2);

    protected abstract boolean shouldAddToEventTreeForNMode(TreeNode<RuleAdapterRuntime.NodeValue> var1, Mutable<TreeNode<RuleAdapterRuntime.NodeValue>> var2, Event var3);

    protected void buildEventTree(TreeNode<RuleAdapterRuntime.NodeValue> node, Event event) {
        boolean isFirstNode = node == null;
        TreeNode newNode = new TreeNode(new RuleAdapterRuntime.NodeValue(event));
        if (isFirstNode) {
            node = newNode;
            this.eventTree.setRoot(node);
        } else {
            node.getChildren().forEach(child -> {
                if (this.adapter.getEventMode(this.getEventIndex((TreeNode<RuleAdapterRuntime.NodeValue>)child)) != EventMode.NONE) {
                    this.buildEventTree((TreeNode<RuleAdapterRuntime.NodeValue>)child, event);
                }
            });
            if (node.getLevel() + 1 >= this.adapter.getEventCount()) {
                return;
            }
            node.addChild(newNode);
        }
        boolean rememberEvent = false;
        EventMode eventMode = this.getEventMode(newNode);
        if (eventMode != null) {
            switch (eventMode) {
                case FIRST: 
                case LAST: 
                case ALL: {
                    rememberEvent = this.shouldAddToEventTreeForFlaModes(newNode, event);
                    break;
                }
                case NONE: {
                    MutableObject newNodeHolder = new MutableObject(newNode);
                    rememberEvent = this.shouldAddToEventTreeForNMode(node, (Mutable<TreeNode<RuleAdapterRuntime.NodeValue>>)newNodeHolder, event);
                    newNode = (TreeNode)newNodeHolder.getValue();
                    break;
                }
                default: {
                    throw new SpongeException("Unsupported value: " + eventMode);
                }
            }
        }
        if (!rememberEvent) {
            if (isFirstNode) {
                this.eventTree.setRoot(null);
            } else {
                node.removeChild(newNode);
            }
        }
    }

    protected EventMode getEventMode(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        return this.adapter.getEventMode(this.getEventIndex(node));
    }

    @Override
    public boolean runRule() {
        return this.runRule(this.eventTree.getRoot());
    }

    protected boolean runRule(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        if (node == null) {
            return false;
        }
        if (this.isLeafLevel(node)) {
            this.prepareEventAliasMap(node);
            if (logger.isDebugEnabled()) {
                logger.debug("Running {}. Event tree: {}", (Object)this.adapter.getName(), this.eventTree);
            }
            ((Rule)this.adapter.getProcessor()).onRun(node.getValue().getEvent());
            EventMode eventMode = this.adapter.getEventMode(this.getEventIndex(node));
            switch (eventMode) {
                case FIRST: {
                    return true;
                }
                case LAST: 
                case NONE: {
                    return true;
                }
                case ALL: {
                    if (this.adapter.isDurationTriggered()) {
                        return true;
                    }
                    node.setValue(null);
                    return false;
                }
            }
            throw new SpongeException("Unsupported value: " + eventMode);
        }
        return this.runRuleForNonFinalNode(node);
    }

    protected abstract boolean isLeafLevel(TreeNode<RuleAdapterRuntime.NodeValue> var1);

    protected abstract boolean runRuleForNonFinalNode(TreeNode<RuleAdapterRuntime.NodeValue> var1);

    @Override
    public void clear() {
        this.eventTree.clear();
        this.eventAliasMap.clear();
    }

    @Override
    public Event getEvent(String eventAlias) {
        Event event = this.eventAliasMap.get(eventAlias);
        if (event == null) {
            throw new SpongeException("Event with alias " + eventAlias + " doesn't exist");
        }
        return event;
    }

    protected void prepareEventAliasMap(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        this.eventAliasMap.clear();
        this.eventTree.getPath(node).forEach(n -> this.eventAliasMap.put(this.adapter.getEventAlias(this.getEventIndex((TreeNode<RuleAdapterRuntime.NodeValue>)n)), ((RuleAdapterRuntime.NodeValue)n.getValue()).getEvent()));
    }

    @Override
    public Tree<RuleAdapterRuntime.NodeValue> getEventTree() {
        return this.eventTree;
    }

    @Override
    public Map<String, Event> getEventAliasMap() {
        return this.eventAliasMap;
    }

    @Override
    public List<Event> getEventSequence() {
        return new ArrayList<Event>(this.eventAliasMap.values());
    }

    @Override
    public Event getFirstEvent() {
        return this.eventTree.getRoot() != null ? this.eventTree.getRoot().getValue().getEvent() : null;
    }

    protected boolean handleNoneEventHappenedButShouldNot(TreeNode<RuleAdapterRuntime.NodeValue> parentNode, TreeNode<RuleAdapterRuntime.NodeValue> node, Event event) {
        if (this.getExpectedEventIndex(node, event) >= 0 && this.checkConditions(node)) {
            this.eventTree.setRoot(null);
            parentNode.removeAllChildren();
            return true;
        }
        return false;
    }
}

