/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.event.EventId;
import org.openksavi.sponge.core.rule.BaseRule;
import org.openksavi.sponge.engine.Engine;
import org.openksavi.sponge.engine.WrappedException;
import org.openksavi.sponge.event.ControlEvent;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.shaded.com.google.common.base.CaseFormat;
import org.openksavi.sponge.shaded.com.google.common.base.Splitter;
import org.openksavi.sponge.shaded.com.google.common.collect.ImmutableMap;
import org.openksavi.sponge.shaded.com.google.common.collect.Streams;
import org.openksavi.sponge.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpongeUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpongeUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trialRunEngine(Engine engine, int timeout) {
        Semaphore semaphore = new Semaphore(0, true);
        engine.startup();
        try {
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.schedule(() -> semaphore.release(), (long)timeout, TimeUnit.SECONDS);
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                logger.warn("trialRunEngine", (Throwable)e);
            }
            executor.shutdown();
        }
        finally {
            engine.shutdown();
        }
    }

    public static <T> T createInstance(String className, Class<T> javaClass) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    public static Object invokeMethod(Object target, String name, Object ... args) {
        try {
            return MethodUtils.invokeMethod((Object)target, (String)name, (Object[])args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    public static <T extends Serializable> T deepClone(T source) {
        return (T)SerializationUtils.clone(source);
    }

    public static Reader getReader(String fileName) throws IOException {
        return SpongeUtils.getReader(fileName, Charset.defaultCharset());
    }

    public static Reader getReader(String fileName, Charset charset) throws IOException {
        Path path = Paths.get(fileName, new String[0]);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return Files.newBufferedReader(Paths.get(fileName, new String[0]), charset);
        }
        URL url = SpongeUtils.getUrlFromClasspath(fileName);
        if (url != null) {
            return new BufferedReader(new InputStreamReader(url.openStream(), charset));
        }
        return null;
    }

    public static URL getUrlFromClasspath(String resourceName) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        return url;
    }

    public static String dumpConfiguration(org.apache.commons.configuration2.Configuration configuration) {
        StringWriter sw = new StringWriter();
        ConfigurationUtils.dump((org.apache.commons.configuration2.Configuration)configuration, (PrintWriter)new PrintWriter(sw));
        return sw.toString();
    }

    public static Object searchConfigurationValueByAttributeValue(Configuration root, String parentKey, String attrName, String attrValue) {
        return Stream.of(root.getChildConfigurationsOf(parentKey)).filter(configuration -> Objects.equals(configuration.getAttribute(attrName, null), attrValue)).map(Configuration::getValue).findFirst().orElse(null);
    }

    public static void executeConcurrentlyOnce(Engine engine, Runnable runnable) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                engine.handleError("executeConcurrentlyOnce", e);
            }
        });
        executor.shutdown();
    }

    public static String createGlobalLoggerName(KnowledgeBaseEngineOperations knowledgeBaseEngineOperations) {
        if (knowledgeBaseEngineOperations != null && knowledgeBaseEngineOperations.getKnowledgeBase() != null) {
            return SpongeUtils.createLoggerName(knowledgeBaseEngineOperations.getKnowledgeBase(), "global");
        }
        return "sponge.kb.global";
    }

    public static String createPluginLoggerName() {
        return "sponge.kb.plugin";
    }

    public static String createLoggerName(KnowledgeBase knowledgeBase, String targetName) {
        return "sponge.kb." + knowledgeBase.getType().getTypeCode() + "." + knowledgeBase.getName() + "." + targetName;
    }

    public static String createNonScriptKnowledgeBaseName(KnowledgeBase knowledgeBase) {
        return knowledgeBase.getClass().getSimpleName();
    }

    public static void shutdownExecutorService(Engine engine, Object named, ExecutorService executorService) {
        MoreExecutors.shutdownAndAwaitTermination(executorService, engine.getDefaultParameters().getExecutorShutdownTimeout(), TimeUnit.SECONDS);
        if (!executorService.isTerminated()) {
            logger.warn("Executor for {} hasn't shutdown gracefully.", named);
        }
    }

    public static ScriptKnowledgeBaseInterpreter getScriptInterpreter(Engine engine, String kbName) {
        return engine.getKnowledgeBaseManager().getScriptKnowledgeBase(kbName).getInterpreter();
    }

    public static KnowledgeBaseEngineOperations getEps(KnowledgeBaseInterpreter interpreter) {
        return (KnowledgeBaseEngineOperations)interpreter.getVariable("EPS", KnowledgeBaseEngineOperations.class);
    }

    public static String getAbbreviatedEventSequenceString(BaseRule rule) {
        return "[" + rule.getEventSequence().stream().map(event -> event != null ? event.getName() + "/" + event.getId() : "<none>").collect(Collectors.joining(", ")) + "]";
    }

    public static SpongeException wrapException(String sourceName, Throwable throwable) {
        if (throwable instanceof SpongeException) {
            return (SpongeException)throwable;
        }
        return new WrappedException(sourceName, throwable);
    }

    public static SpongeException wrapException(Throwable throwable) {
        if (throwable instanceof SpongeException) {
            return (SpongeException)throwable;
        }
        return new SpongeException(throwable);
    }

    public static boolean containsException(Throwable exception, Class<?> type) {
        return ExceptionUtils.indexOfType((Throwable)exception, type) > -1;
    }

    public static <T> T getException(Throwable exception, Class<T> type) {
        return (T)ExceptionUtils.getThrowableList((Throwable)exception).get(ExceptionUtils.indexOfType((Throwable)exception, type));
    }

    public static String getSourceName(Throwable exception) {
        return exception instanceof WrappedException ? ((WrappedException)exception).getSourceName() : null;
    }

    public static String toStringEventSequence(Collection<Event> events) {
        return SpongeUtils.toStringEventSequence(events, null);
    }

    public static String toStringEventSequence(Collection<Event> events, String attributeName) {
        return events.stream().map(event -> event != null ? event.getName() + "(" + EventId.fromString(event.getId()).getId() + ")" + (attributeName != null ? "/" + event.get(attributeName) : "") : "null").collect(Collectors.joining(", "));
    }

    public static String toStringArrayEventSequence(Collection<Event> events, String attributeName) {
        return "{ " + events.stream().map(event -> event != null ? "\"" + event.get(attributeName) + "\"" : "null").collect(Collectors.joining(", ")) + " }";
    }

    public static String createControlEventName(Class<? extends ControlEvent> controlEventClass) {
        return "$" + StringUtils.uncapitalize((String)controlEventClass.getSimpleName());
    }

    public static int calculateInitialDynamicThreadPoolSize(Engine engine, int maxPoolSize) {
        int result = (int)Math.round(engine.getDefaultParameters().getInitialDynamicThreadPoolSizeRatio() * (double)maxPoolSize);
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    public static String getPackagePath(Class<?> cls) {
        return cls.getPackage().getName().replace('.', '/');
    }

    public static String getLastSubdirectory(String dir) {
        try {
            List subdirs = Files.list(Paths.get(dir, new String[0])).map(path -> path.getFileName().toFile().getName()).sorted().collect(Collectors.toList());
            return subdirs.size() > 0 ? (String)subdirs.get(subdirs.size() - 1) : null;
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1) {
        return ImmutableMap.of(k1, v1);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, v1, k2, v2);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return ImmutableMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return Streams.stream(iterator);
    }

    public static List<String> split(String text, char separator) {
        return Splitter.on(separator).trimResults().omitEmptyStrings().splitToList(text);
    }

    public static void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static void close(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static String getRequiredConfigurationString(Configuration configuration, String key) {
        String value = configuration.getString(key, null);
        if (value == null) {
            throw new IllegalArgumentException("A required configuration parameter '" + key + "' is not set");
        }
        return value;
    }

    public static int toInt(Object value) {
        return ((Number)value).intValue();
    }

    public static void registerShutdownHook(Engine engine) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                engine.shutdown();
            }
            catch (Throwable e) {
                logger.error("Shutdown hook error", e);
            }
        }));
    }

    public static String toUpperCamelCaseFromUnderscore(String s) {
        return s != null ? CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s.toLowerCase()) : null;
    }

    public static boolean isAbstract(Class<?> cls) {
        return Modifier.isAbstract(cls.getModifiers());
    }

    protected SpongeUtils() {
    }
}

