/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.CategoryMeta;
import org.openksavi.sponge.EngineOperations;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.event.DefaultEventDefinition;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.core.util.process.DefaultProcessDefinition;
import org.openksavi.sponge.correlator.CorrelatorMeta;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.event.EventDefinition;
import org.openksavi.sponge.event.EventSchedulerEntry;
import org.openksavi.sponge.filter.FilterMeta;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.rule.RuleMeta;
import org.openksavi.sponge.trigger.TriggerMeta;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.RecordType;
import org.openksavi.sponge.type.provided.ProvidedValue;
import org.openksavi.sponge.util.DataTypeSupplier;
import org.openksavi.sponge.util.ProcessorPredicate;
import org.openksavi.sponge.util.ValueHolder;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.openksavi.sponge.util.process.ProcessConfigurationBuilder;
import org.openksavi.sponge.util.process.ProcessDefinition;

public class BaseEngineOperations
implements EngineOperations {
    protected BaseSpongeEngine engine;

    public BaseEngineOperations(BaseSpongeEngine engine) {
        this.engine = engine;
    }

    public BaseSpongeEngine getEngine() {
        return this.engine;
    }

    public Object call(String actionName, List<Object> args) {
        return this.engine.getActionManager().callAction(actionName, args);
    }

    public <T> T call(Class<T> resultClass, String actionName, List<Object> args) {
        Object result = this.call(actionName, args);
        Validate.isTrue((result == null || resultClass.isInstance(result) ? 1 : 0) != 0, (String)"Action result cannot be cast to expected class %s", (Object[])new Object[]{resultClass});
        return (T)result;
    }

    public Object call(String actionName) {
        return this.call(actionName, Collections.emptyList());
    }

    public <T> T call(Class<T> resultClass, String actionName) {
        return this.call(resultClass, actionName, Collections.emptyList());
    }

    public ValueHolder<Object> callIfExists(String actionName, List<Object> args) {
        return this.engine.getActionManager().callActionIfExists(actionName, args);
    }

    public <T> ValueHolder<T> callIfExists(Class<T> resultClass, String actionName, List<Object> args) {
        ValueHolder<Object> resultHolder = this.callIfExists(actionName, args);
        if (resultHolder == null) {
            return null;
        }
        Object result = resultHolder.getValue();
        Validate.isTrue((result == null || resultClass.isInstance(result) ? 1 : 0) != 0, (String)"Action result cannot be cast to expected class %s", (Object[])new Object[]{resultClass});
        return new ValueHolder(result);
    }

    public ValueHolder<Object> callIfExists(String actionName) {
        return this.callIfExists(actionName, Collections.emptyList());
    }

    public <T> ValueHolder<T> callIfExists(Class<T> resultClass, String actionName) {
        return this.callIfExists(resultClass, actionName, Collections.emptyList());
    }

    public Map<String, ProvidedValue<?>> provideActionArgs(String actionName, List<String> argNames, Map<String, Object> current) {
        ActionAdapter actionAdapter = (ActionAdapter)Validate.notNull((Object)this.engine.getActionManager().getActionAdapter(actionName), (String)"Action '%s' not found", (Object[])new Object[]{actionName});
        try {
            return actionAdapter.provideArgs(argNames, current);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(actionAdapter.getProcessor(), e);
        }
    }

    public Map<String, ProvidedValue<?>> provideActionArgs(String actionName, List<String> argNames) {
        return this.provideActionArgs(actionName, argNames, null);
    }

    public Map<String, ProvidedValue<?>> provideActionArgs(String actionName) {
        return this.provideActionArgs(actionName, null);
    }

    public boolean removeEvent(EventSchedulerEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Event entry cannot be null");
        }
        return this.engine.getEventScheduler().remove(entry);
    }

    public <T extends Plugin> T getPlugin(String name) {
        return (T)((Plugin)Validate.notNull((Object)this.engine.getPluginManager().getPlugin(name), (String)"Plugin named %s is not registered", (Object[])new Object[]{name}));
    }

    public <T extends Plugin> T getPlugin(Class<T> cls, String name) {
        return (T)((Plugin)Validate.notNull((Object)this.engine.getPluginManager().getPlugin(cls, name), (String)"Plugin named %s of class %s is not registered", (Object[])new Object[]{name, cls}));
    }

    public <T extends Plugin> T getPlugin(Class<T> cls) {
        return (T)((Plugin)Validate.notNull((Object)this.engine.getPluginManager().getPlugin(cls), (String)"Plugin of class %s is not registered", (Object[])new Object[]{cls}));
    }

    public boolean hasPlugin(String name) {
        return this.engine.getPluginManager().getPlugin(name) != null;
    }

    public <T extends Plugin> boolean hasPlugin(Class<T> cls, String name) {
        return this.engine.getPluginManager().getPlugin(cls, name) != null;
    }

    public <T extends Plugin> boolean hasPlugin(Class<T> cls) {
        return this.engine.getPluginManager().getPlugin(cls) != null;
    }

    public String getVersion() {
        return this.engine.getVersion();
    }

    public String getInfo() {
        return this.engine.getInfo();
    }

    public String getStatisticsSummary() {
        return this.engine.getStatisticsManager().getSummary();
    }

    public EventDefinition event(String name) {
        return new DefaultEventDefinition(this, name, this.engine.getConfigurationManager().getEventClonePolicy());
    }

    public EventDefinition event(String name, EventClonePolicy policy) {
        return new DefaultEventDefinition(this, name, policy);
    }

    public EventDefinition event(Event event) {
        return new DefaultEventDefinition(this, event);
    }

    public void shutdown() {
        this.engine.shutdown();
    }

    public void requestShutdown() {
        this.engine.requestShutdown();
    }

    public void reload() {
        this.engine.reload();
    }

    public void requestReload() {
        this.engine.requestReload();
    }

    public boolean hasAction(String name) {
        return this.engine.getActionManager().hasAction(name);
    }

    public boolean hasFilter(String name) {
        return this.engine.getFilterProcessingUnit().hasProcessor(name);
    }

    public boolean hasTrigger(String name) {
        return this.engine.getMainProcessingUnit().hasProcessor(name);
    }

    public boolean hasRule(String name) {
        return this.engine.getMainProcessingUnit().hasProcessor(name);
    }

    public boolean hasCorrelator(String name) {
        return this.engine.getMainProcessingUnit().hasProcessor(name);
    }

    public void setVariable(String name, Object value) {
        this.engine.getSession().setVariable(name, value);
    }

    public <T> T getVariable(String name) {
        return (T)this.engine.getSession().getVariable(name);
    }

    public <T> T getVariable(Class<T> cls, String name) {
        return (T)this.engine.getSession().getVariable(cls, name);
    }

    public <T> T getVariable(String name, T defaultValue) {
        return (T)this.engine.getSession().getVariable(name, defaultValue);
    }

    public <T> T getVariable(Class<T> cls, String name, T defaultValue) {
        return (T)this.engine.getSession().getVariable(cls, name, defaultValue);
    }

    public boolean hasVariable(String name) {
        return this.engine.getSession().hasVariable(name);
    }

    public void removeVariable(String name) {
        this.engine.getSession().removeVariable(name);
    }

    public <T> void setVariableIfNone(String name, Supplier<T> supplier) {
        this.engine.getSession().setVariableIfNone(name, supplier);
    }

    public void updateVariable(String name) {
        this.engine.getSession().updateVariable(name);
    }

    protected String getProperty(String name, String defaultValue, boolean throwException) {
        String result = this.engine.getConfigurationManager().getProperty(name);
        Validate.isTrue((result != null || !throwException ? 1 : 0) != 0, (String)"Property '%s' not found or empty", (Object[])new Object[]{name});
        return result != null ? result : defaultValue;
    }

    public String getProperty(String name) {
        return this.getProperty(name, null, true);
    }

    public String getProperty(String name, String defaultValue) {
        return this.getProperty(name, defaultValue, false);
    }

    public boolean hasProperty(String name) {
        return this.engine.getConfigurationManager().getProperty(name) != null;
    }

    public String getHome() {
        return this.engine.getConfigurationManager().getHome();
    }

    public ProcessDefinition process(ProcessConfiguration processConfiguration) {
        return new DefaultProcessDefinition(this.engine, processConfiguration);
    }

    public ProcessDefinition process(ProcessConfigurationBuilder processConfigurationBuilder) {
        return this.process(processConfigurationBuilder.build());
    }

    public void addCategory(CategoryMeta categoryMeta) {
        this.engine.addCategory(categoryMeta);
    }

    public void addCategories(CategoryMeta ... categoryMeta) {
        this.engine.addCategories(categoryMeta);
    }

    public CategoryMeta getCategory(String categoryName) {
        return this.engine.getCategory(categoryName);
    }

    public boolean hasCategory(String categoryName) {
        return this.engine.hasCategory(categoryName);
    }

    public CategoryMeta removeCategory(String categoryName) {
        return this.engine.removeCategory(categoryName);
    }

    public List<CategoryMeta> getCategories() {
        return this.engine.getCategories();
    }

    public void selectCategory(String categoryName, ProcessorType processorType, ProcessorPredicate predicate) {
        this.engine.selectCategory(categoryName, processorType, predicate);
    }

    public void selectCategory(String categoryName, ProcessorPredicate predicate) {
        this.engine.selectCategory(categoryName, predicate);
    }

    public ActionMeta getActionMeta(String actionName) {
        return this.engine.getActionMeta(actionName);
    }

    public FilterMeta getFilterMeta(String filterName) {
        return this.engine.getFilterMeta(filterName);
    }

    public TriggerMeta getTriggerMeta(String triggerName) {
        return this.engine.getTriggerMeta(triggerName);
    }

    public CorrelatorMeta getCorrelatorMeta(String correlatorName) {
        return this.engine.getCorrelatorMeta(correlatorName);
    }

    public RuleMeta getRuleMeta(String ruleName) {
        return this.engine.getRuleMeta(ruleName);
    }

    public <T extends DataType<?>> void addType(String registeredTypeName, DataTypeSupplier<T> typeSupplier) {
        this.engine.addType(registeredTypeName, typeSupplier);
    }

    public <T extends DataType<?>> T getType(String registeredTypeName) {
        return this.engine.getType(registeredTypeName);
    }

    public <T extends DataType<?>> T getType(String registeredTypeName, String locationName) {
        return this.engine.getType(registeredTypeName, locationName);
    }

    public Map<String, DataType> getTypes() {
        return this.engine.getTypes();
    }

    public boolean hasType(String registeredTypeName) {
        return this.engine.hasType(registeredTypeName);
    }

    public boolean removeType(String registeredTypeName) {
        return this.engine.removeType(registeredTypeName);
    }

    public void addEventType(String eventTypeName, RecordType dataType) {
        this.engine.addEventType(eventTypeName, dataType);
    }

    public RecordType getEventType(String eventTypeName) {
        return this.engine.getEventType(eventTypeName);
    }

    public boolean hasEventType(String eventTypeName) {
        return this.engine.hasEventType(eventTypeName);
    }

    public Map<String, RecordType> getEventTypes() {
        return this.engine.getEventTypes();
    }

    public boolean removeEventType(String eventTypeName) {
        return this.engine.removeEventType(eventTypeName);
    }
}

