/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.Map;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.ProcessorAdapterFactory;
import org.openksavi.sponge.core.BaseProcessorAdapter;
import org.openksavi.sponge.core.BaseProcessorMeta;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.slf4j.Logger;

public abstract class BaseProcessor<T extends ProcessorAdapter<?>>
implements Processor<T>,
ProcessorAdapterFactory<T> {
    private T adapter;

    public void onInit() {
    }

    public final T getAdapter() {
        return this.adapter;
    }

    public final void setAdapter(T adapter) {
        this.adapter = adapter;
    }

    public BaseProcessorMeta getMeta() {
        return (BaseProcessorMeta)this.adapter.getMeta();
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.adapter.getKnowledgeBase();
    }

    public KnowledgeBaseEngineOperations getSponge() {
        return this.getKnowledgeBase().getEngineOperations();
    }

    public KnowledgeBase getKb() {
        return this.getKnowledgeBase();
    }

    public final Logger getLogger() {
        return ((BaseProcessorAdapter)this.adapter).getLogger();
    }

    public BaseProcessor<T> withName(String name) {
        this.getMeta().withName(name);
        return this;
    }

    public BaseProcessor<T> withLabel(String label) {
        this.getMeta().withLabel(label);
        return this;
    }

    public BaseProcessor<T> withDescription(String description) {
        this.getMeta().withDescription(description);
        return this;
    }

    public BaseProcessor<T> withVersion(Integer version) {
        this.getMeta().withVersion(version);
        return this;
    }

    public BaseProcessor<T> withFeatures(Map<String, Object> features) {
        this.getMeta().withFeatures(features);
        return this;
    }

    public BaseProcessor<T> withFeature(String name, Object value) {
        this.getMeta().withFeature(name, value);
        return this;
    }

    public BaseProcessor<T> withCategory(String category) {
        this.getMeta().withCategory(category);
        return this;
    }

    public String toString() {
        return this.getMeta().getName() != null ? this.getMeta().getName() : super.toString();
    }
}

