/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import org.openksavi.sponge.ProcessorDefinition;
import org.openksavi.sponge.ProcessorMeta;
import org.openksavi.sponge.core.kb.BaseKnowledgeBase;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.kb.KnowledgeBase;

public abstract class BaseProcessorDefinition
implements ProcessorDefinition {
    private boolean javaDefined = false;
    private Class<?> processorClass;
    private KnowledgeBase knowledgeBase;
    private ProcessorMeta meta;

    protected BaseProcessorDefinition(ProcessorMeta meta) {
        this.meta = meta;
    }

    public ProcessorMeta getMeta() {
        return this.meta;
    }

    public String toString() {
        return this.getMeta().getLabel() != null ? this.getMeta().getLabel() : this.getMeta().getName();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw SpongeUtils.wrapException(this.getMeta().getName(), (Throwable)e);
        }
    }

    public void setJavaDefined(boolean javaDefined) {
        this.javaDefined = javaDefined;
    }

    public boolean isJavaDefined() {
        return this.javaDefined;
    }

    public Class<?> getProcessorClass() {
        return this.processorClass;
    }

    public void setProcessorClass(Class<?> processorClass) {
        this.processorClass = processorClass;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(BaseKnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }
}

