/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.CategoryMeta;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.EventSetProcessorAdapterGroup;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.core.VersionInfo;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.DefaultEngineParameters;
import org.openksavi.sponge.core.engine.DefaultSession;
import org.openksavi.sponge.core.engine.GenericExceptionContext;
import org.openksavi.sponge.core.engine.LoggingExceptionHandler;
import org.openksavi.sponge.core.engine.processing.QueuedEventSetProcessorDurationStrategy;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseEngineOperations;
import org.openksavi.sponge.core.kb.DefaultKnowledgeBaseFileProvider;
import org.openksavi.sponge.core.spi.DefaultEngineModuleProvider;
import org.openksavi.sponge.core.spi.DefaultEventQueueProvider;
import org.openksavi.sponge.core.spi.DefaultProcessingUnitProvider;
import org.openksavi.sponge.core.util.RegexPatternMatcher;
import org.openksavi.sponge.core.util.ServiceLoaderUtils;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.correlator.CorrelatorAdapterGroup;
import org.openksavi.sponge.correlator.CorrelatorMeta;
import org.openksavi.sponge.engine.ActionManager;
import org.openksavi.sponge.engine.ConfigurationManager;
import org.openksavi.sponge.engine.EngineModule;
import org.openksavi.sponge.engine.EngineParameters;
import org.openksavi.sponge.engine.EventQueueManager;
import org.openksavi.sponge.engine.ExceptionContext;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.openksavi.sponge.engine.KnowledgeBaseManager;
import org.openksavi.sponge.engine.OnShutdownListener;
import org.openksavi.sponge.engine.OnStartupListener;
import org.openksavi.sponge.engine.PluginManager;
import org.openksavi.sponge.engine.ProcessingUnitManager;
import org.openksavi.sponge.engine.ProcessorManager;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.Session;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.engine.StatisticsManager;
import org.openksavi.sponge.engine.ThreadPoolManager;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.engine.event.EventScheduler;
import org.openksavi.sponge.engine.processing.EventSetProcessorDurationStrategy;
import org.openksavi.sponge.engine.processing.MainProcessingUnit;
import org.openksavi.sponge.engine.processing.ProcessingUnit;
import org.openksavi.sponge.filter.FilterAdapter;
import org.openksavi.sponge.filter.FilterMeta;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseFileProvider;
import org.openksavi.sponge.plugin.Plugin;
import org.openksavi.sponge.rule.RuleAdapterGroup;
import org.openksavi.sponge.rule.RuleMeta;
import org.openksavi.sponge.spi.EngineModuleProvider;
import org.openksavi.sponge.spi.EventQueueProvider;
import org.openksavi.sponge.spi.KnowledgeBaseInterpreterFactoryProvider;
import org.openksavi.sponge.spi.ProcessingUnitProvider;
import org.openksavi.sponge.trigger.TriggerAdapter;
import org.openksavi.sponge.trigger.TriggerMeta;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.RecordType;
import org.openksavi.sponge.util.DataTypeSupplier;
import org.openksavi.sponge.util.PatternMatcher;
import org.openksavi.sponge.util.ProcessorPredicate;
import org.openksavi.sponge.util.SpongeApiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseSpongeEngine
extends BaseEngineModule
implements SpongeEngine {
    private static final Logger logger = LoggerFactory.getLogger(BaseSpongeEngine.class);
    protected EngineModuleProvider moduleProvider;
    protected List<KnowledgeBaseInterpreterFactoryProvider> knowledgeBaseInterpreterFactoryProviders;
    protected EventQueueProvider eventQueueProvider;
    protected ProcessingUnitProvider processingUnitProvider;
    protected KnowledgeBaseFileProvider knowledgeBaseFileProvider;
    protected EventScheduler eventScheduler;
    protected EventQueueManager eventQueueManager;
    protected ThreadPoolManager threadPoolManager;
    protected KnowledgeBaseManager knowledgeBaseManager;
    protected PluginManager pluginManager;
    protected ConfigurationManager configurationManager;
    protected StatisticsManager statisticsManager;
    protected Session session = DefaultSession.createNewSession();
    protected Lock lock = new ReentrantLock(true);
    protected ProcessorManager processorManager;
    protected ProcessingUnitManager processingUnitManager;
    protected ActionManager actionManager;
    protected EventQueue inputQueue;
    private AtomicReference<Throwable> rememberedException = new AtomicReference();
    private String configurationFilename;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private AtomicBoolean endlessLoopMode = new AtomicBoolean(true);
    private KnowledgeBaseEngineOperations operations;
    private ExceptionHandler exceptionHandler = new LoggingExceptionHandler();
    private List<OnStartupListener> onStartupListeners = new CopyOnWriteArrayList<OnStartupListener>();
    private List<OnShutdownListener> onShutdownListeners = new CopyOnWriteArrayList<OnShutdownListener>();
    private VersionInfo versionInfo = new VersionInfo();
    private EngineParameters defaultParameters = new DefaultEngineParameters();
    private EventSetProcessorDurationStrategy durationStrategy = new QueuedEventSetProcessorDurationStrategy();
    private PatternMatcher patternMatcher = new RegexPatternMatcher();
    private Map<String, CategoryMeta> categories = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, DataTypeSupplier> types = new ConcurrentSkipListMap<String, DataTypeSupplier>();
    private Map<String, RecordType> eventTypes = new ConcurrentSkipListMap<String, RecordType>();

    public BaseSpongeEngine() {
        this.setEngine(this);
    }

    public EngineModuleProvider getModuleProvider() {
        return this.moduleProvider;
    }

    public void setModuleProvider(EngineModuleProvider moduleProvider) {
        this.moduleProvider = moduleProvider;
    }

    public List<KnowledgeBaseInterpreterFactoryProvider> getKnowledgeBaseInterpreterFactoryProviders() {
        return this.knowledgeBaseInterpreterFactoryProviders;
    }

    public void setKnowledgeBaseInterpreterFactoryProviders(List<KnowledgeBaseInterpreterFactoryProvider> knowledgeBaseInterpreterFactoryProviders) {
        this.knowledgeBaseInterpreterFactoryProviders = knowledgeBaseInterpreterFactoryProviders;
    }

    public void setEventQueueProvider(EventQueueProvider eventQueueProvider) {
        this.eventQueueProvider = eventQueueProvider;
    }

    public void setProcessingUnitProvider(ProcessingUnitProvider processingUnitProvider) {
        this.processingUnitProvider = processingUnitProvider;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public String getConfigurationFilename() {
        return this.configurationFilename;
    }

    public void setConfigurationFilename(String configurationFilename) {
        this.configurationFilename = configurationFilename;
    }

    public void init() {
        this.lock.lock();
        try {
            if (this.initialized.get()) {
                return;
            }
            this.ensureProvidersSet();
            this.configurationManager = this.moduleProvider.createConfigurationManager((SpongeEngine)this, this.configurationFilename);
            this.pluginManager = this.moduleProvider.createPluginManager((SpongeEngine)this);
            this.knowledgeBaseManager = this.moduleProvider.createKnowledgeBaseManager((SpongeEngine)this);
            this.threadPoolManager = this.moduleProvider.createThreadPoolManager((SpongeEngine)this);
            this.processorManager = this.moduleProvider.createProcessorManager((SpongeEngine)this);
            this.actionManager = this.moduleProvider.createActionManager((SpongeEngine)this);
            this.statisticsManager = this.moduleProvider.createStatisticsManager((SpongeEngine)this);
            this.processingUnitManager = this.moduleProvider.createProcessingUnitManager((SpongeEngine)this);
            this.eventQueueManager = this.moduleProvider.createEventQueueManager((SpongeEngine)this);
            this.operations = new BaseKnowledgeBaseEngineOperations(this, this.knowledgeBaseManager.getDefaultKnowledgeBase());
            this.initialized.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void ensureProvidersSet() {
        if (this.moduleProvider == null) {
            this.moduleProvider = ServiceLoaderUtils.loadService(EngineModuleProvider.class);
            if (this.moduleProvider == null) {
                this.moduleProvider = new DefaultEngineModuleProvider();
            }
        }
        if (this.knowledgeBaseInterpreterFactoryProviders == null) {
            this.knowledgeBaseInterpreterFactoryProviders = ServiceLoaderUtils.loadServices(KnowledgeBaseInterpreterFactoryProvider.class);
        }
        if (this.eventQueueProvider == null) {
            this.eventQueueProvider = new DefaultEventQueueProvider();
        }
        if (this.processingUnitProvider == null) {
            this.processingUnitProvider = new DefaultProcessingUnitProvider();
        }
        if (this.knowledgeBaseFileProvider == null) {
            this.knowledgeBaseFileProvider = new DefaultKnowledgeBaseFileProvider();
        }
    }

    @Override
    public synchronized void startup() {
        this.endlessLoopMode.set(true);
        super.startup();
        if (!this.endlessLoopMode.get()) {
            this.shutdown();
        }
    }

    @Override
    public void doStartup() {
        this.lock.lock();
        try {
            logger.info("Starting up {}", (Object)this.getInfo());
            this.init();
            try {
                this.clearRememberedException();
                this.configurationManager.startup();
                this.configureEngineModules();
                this.eventQueueManager.startup();
                this.eventScheduler.startup();
                this.operations.event("startup").send();
                this.knowledgeBaseManager.startup();
                this.pluginManager.startup();
                this.onStartupListeners.forEach(listener -> listener.onStartup());
                this.knowledgeBaseManager.onStartup();
                if (this.knowledgeBaseManager.onRun()) {
                    this.threadPoolManager.startup();
                    this.processingUnitManager.startup();
                    logger.debug("Sponge is running");
                } else {
                    this.endlessLoopMode.set(false);
                    logger.debug("Sponge completed a run once mode");
                }
            }
            catch (Throwable e) {
                this.safelyShutdownIfStartupError(new EngineModule[]{this.processingUnitManager, this.threadPoolManager, this.knowledgeBaseManager, this.pluginManager, this.eventScheduler, this.eventQueueManager, this.configurationManager});
                throw SpongeUtils.wrapException("startup", e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void safelyShutdownIfStartupError(EngineModule ... modules) {
        Stream.of(modules).forEachOrdered(module -> {
            try {
                if (module != null && module.isRunning()) {
                    module.shutdown();
                }
            }
            catch (Throwable ex) {
                logger.warn(module.getName(), ex);
            }
        });
    }

    protected void setupEngineDescriptive() {
        if (this.getName() == null && this.configurationManager.getEngineName() != null) {
            this.setName(this.configurationManager.getEngineName());
        }
        if (this.getLabel() == null && this.configurationManager.getEngineLabel() != null) {
            this.setLabel(this.configurationManager.getEngineLabel());
        }
        if (this.getDescription() == null && this.configurationManager.getEngineDescription() != null) {
            this.setDescription(this.configurationManager.getEngineDescription());
        }
    }

    @Override
    public void doShutdown() {
        this.lock.lock();
        try {
            logger.info("Shutting down Sponge");
            AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
            this.safelyShutdownModule((EngineModule)this.processingUnitManager, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.threadPoolManager, exceptionHolder);
            this.knowledgeBaseManager.onShutdown();
            this.onShutdownListeners.forEach(listener -> listener.onShutdown());
            this.safelyShutdownModule((EngineModule)this.pluginManager, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.knowledgeBaseManager, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.eventScheduler, exceptionHolder);
            this.safelyShutdownModule((EngineModule)this.eventQueueManager, exceptionHolder);
            if (exceptionHolder.get() != null) {
                throw (Throwable)exceptionHolder.get();
            }
            logger.debug("Sponge is terminated");
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException("shutdown", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void requestShutdown() {
        SpongeUtils.executeConcurrentlyOnce(this, () -> this.shutdown(), "shutdown");
    }

    private void safelyShutdownModule(EngineModule module, AtomicReference<Throwable> exceptionHolder) {
        block3: {
            try {
                if (module != null) {
                    module.shutdown();
                }
            }
            catch (Throwable e) {
                if (exceptionHolder.get() != null) break block3;
                exceptionHolder.set(e);
            }
        }
    }

    protected void configureEngineModules() {
        this.setupEngineDescriptive();
        this.knowledgeBaseManager.setKnowledgeBaseInterpreterFactoryProviders(this.knowledgeBaseInterpreterFactoryProviders);
        this.inputQueue = this.eventQueueProvider.getInputQueue();
        EventQueue mainProcessingQueue = this.eventQueueProvider.getMainQueue();
        EventQueue outputQueue = this.eventQueueProvider.getOutputQueue();
        this.eventQueueManager.setInputEventQueue(this.inputQueue);
        this.eventQueueManager.setMainEventQueue(mainProcessingQueue);
        this.eventQueueManager.setOutputEventQueue(outputQueue);
        this.inputQueue.setCapacity(this.configurationManager.getEventQueueCapacity());
        mainProcessingQueue.setCapacity(this.getDefaultParameters().getMainEventQueueCapacity());
        this.eventScheduler = this.moduleProvider.createEventScheduler((SpongeEngine)this, this.inputQueue);
        this.processingUnitManager.setFilterProcessingUnit(this.processingUnitProvider.createFilterProcessingUnit((SpongeEngine)this, this.inputQueue, mainProcessingQueue));
        this.processingUnitManager.setMainProcessingUnit(this.processingUnitProvider.createMainProcessingUnit((SpongeEngine)this, mainProcessingQueue, outputQueue));
        this.configurationManager.getPreConfigPlugins().forEach(plugin -> this.pluginManager.addPlugin(plugin));
        if (this.configurationManager.getRootConfig() != null) {
            this.pluginManager.configure(this.configurationManager.getRootConfig());
        }
        this.configurationManager.getPostConfigPlugins().forEach(plugin -> this.pluginManager.addPlugin(plugin));
        this.configurationManager.getPreConfigKnowledgeBases().forEach(knowledgeBase -> this.knowledgeBaseManager.addKnowledgeBase(knowledgeBase));
        if (this.configurationManager.getRootConfig() != null) {
            this.knowledgeBaseManager.configure(this.configurationManager.getRootConfig());
        }
        this.configurationManager.getPostConfigKnowledgeBases().forEach(knowledgeBase -> this.knowledgeBaseManager.addKnowledgeBase(knowledgeBase));
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public KnowledgeBaseManager getKnowledgeBaseManager() {
        return this.knowledgeBaseManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public EventScheduler getEventScheduler() {
        return this.eventScheduler;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public ProcessingUnitManager getProcessingUnitManager() {
        return this.processingUnitManager;
    }

    public ThreadPoolManager getThreadPoolManager() {
        return this.threadPoolManager;
    }

    public List<FilterAdapter> getFilters() {
        return new ArrayList<FilterAdapter>(this.getFilterProcessingUnit().getRegisteredProcessorAdapterMap().values());
    }

    public List<TriggerAdapter> getTriggers() {
        return this.getMainProcessingUnit().getTriggerAdapters();
    }

    public List<RuleAdapterGroup> getRuleGroups() {
        return this.getMainProcessingUnit().getRuleAdapterGroups();
    }

    public List<CorrelatorAdapterGroup> getCorrelatorGroups() {
        return this.getMainProcessingUnit().getCorrelatorAdapterGroups();
    }

    public List<ActionAdapter> getActions() {
        return new ArrayList<ActionAdapter>(this.actionManager.getRegisteredActionAdapterMap().values());
    }

    public List<ProcessorAdapter> getProcessors() {
        ArrayList<ProcessorAdapter> adapters = new ArrayList<ProcessorAdapter>();
        adapters.addAll(this.getActions());
        adapters.addAll(this.getFilters());
        adapters.addAll(this.getTriggers());
        adapters.addAll(this.getRuleGroups());
        adapters.addAll(this.getCorrelatorGroups());
        return adapters;
    }

    public void reload() {
        this.lock.lock();
        try {
            this.pluginManager.onBeforeReload();
            this.knowledgeBaseManager.reload();
            this.pluginManager.onAfterReload();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void requestReload() {
        SpongeUtils.executeConcurrentlyOnce(this, () -> this.reload(), "reload");
    }

    public void handleError(ProcessorAdapter<?> processorAdapter, Throwable e) {
        this.handleError(processorAdapter != null && processorAdapter.getMeta().getName() != null ? SpongeUtils.getProcessorQualifiedName(processorAdapter).toString() : "unknown", processorAdapter, e);
    }

    public void handleError(String sourceName, Throwable e) {
        this.handleError(sourceName, null, e);
    }

    protected void handleError(String sourceName, Object sourceObject, Throwable exception) {
        this.tryRememberException(exception);
        this.exceptionHandler.handleException(exception, (ExceptionContext)new GenericExceptionContext(this, (String)ObjectUtils.defaultIfNull((Object)SpongeUtils.getSourceName(exception), (Object)sourceName), sourceObject));
    }

    public List<Plugin> getPlugins() {
        return this.pluginManager.getPlugins();
    }

    public String getVersion() {
        return this.versionInfo.getVersion();
    }

    public String getInfo() {
        return this.versionInfo.getInfo(this.getName());
    }

    protected void tryRememberException(Throwable e) {
        this.rememberedException.updateAndGet(previous -> previous != null ? previous : e);
    }

    public void clearRememberedException() {
        this.rememberedException.set(null);
    }

    public EventQueueManager getEventQueueManager() {
        return this.eventQueueManager;
    }

    public ProcessingUnit<FilterAdapter> getFilterProcessingUnit() {
        return this.processingUnitManager.getFilterProcessingUnit();
    }

    public MainProcessingUnit getMainProcessingUnit() {
        return this.processingUnitManager.getMainProcessingUnit();
    }

    public ProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public EventQueue getInputQueue() {
        return this.inputQueue;
    }

    public AtomicReference<Throwable> getRememberedException() {
        return this.rememberedException;
    }

    public boolean isError() {
        return this.rememberedException.get() != null;
    }

    public Throwable getError() {
        return this.rememberedException.get();
    }

    public void clearError() {
        this.clearRememberedException();
    }

    public KnowledgeBaseEngineOperations getOperations() {
        return this.operations;
    }

    public Session getSession() {
        return this.session;
    }

    public KnowledgeBaseFileProvider getKnowledgeBaseFileProvider() {
        return this.knowledgeBaseFileProvider;
    }

    public void setKnowledgeBaseFileProvider(KnowledgeBaseFileProvider knowledgeBaseFileProvider) {
        this.knowledgeBaseFileProvider = knowledgeBaseFileProvider;
    }

    public void addOnStartupListener(OnStartupListener onStartupListener) {
        this.onStartupListeners.add(onStartupListener);
    }

    public boolean removeOnStartupListener(OnStartupListener onStartupListener) {
        return this.onStartupListeners.remove(onStartupListener);
    }

    public List<OnStartupListener> getOnStartupListeners() {
        return this.onStartupListeners;
    }

    public void addOnShutdownListener(OnShutdownListener onShutdownListener) {
        this.onShutdownListeners.add(onShutdownListener);
    }

    public boolean removeOnShutdownListener(OnShutdownListener onShutdownListener) {
        return this.onShutdownListeners.remove(onShutdownListener);
    }

    public List<OnShutdownListener> getOnShutdownListeners() {
        return this.onShutdownListeners;
    }

    public EngineParameters getDefaultParameters() {
        return this.defaultParameters;
    }

    public EventSetProcessorDurationStrategy getEventSetProcessorDurationStrategy() {
        return this.durationStrategy;
    }

    public void setEventSetProcessorDurationStrategy(EventSetProcessorDurationStrategy durationStrategy) {
        this.durationStrategy = durationStrategy;
    }

    public PatternMatcher getPatternMatcher() {
        return this.patternMatcher;
    }

    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    public void addCategory(CategoryMeta categoryMeta) {
        this.categories.put(categoryMeta.getName(), categoryMeta);
    }

    public void addCategories(CategoryMeta ... categoryMeta) {
        Arrays.stream(categoryMeta).forEach(this::addCategory);
    }

    public CategoryMeta getCategory(String categoryName) {
        return (CategoryMeta)Validate.notNull((Object)this.categories.get(categoryName), (String)"Category %s is not registered", (Object[])new Object[]{categoryName});
    }

    public boolean hasCategory(String categoryName) {
        return this.categories.containsKey(categoryName);
    }

    public CategoryMeta removeCategory(String categoryName) {
        Validate.isTrue((!this.getProcessorManager().getAllProcessorAdapters().stream().map(adapter -> adapter.getMeta().getCategory()).anyMatch(adapterCategory -> adapterCategory != null && adapterCategory.equals(categoryName)) ? 1 : 0) != 0, (String)"The category %s is being used and can't be removed", (Object[])new Object[]{categoryName});
        return this.categories.remove(categoryName);
    }

    public List<CategoryMeta> getCategories() {
        return Collections.unmodifiableList(new ArrayList<CategoryMeta>(this.categories.values()));
    }

    public void selectCategory(String categoryName, ProcessorType processorType, ProcessorPredicate predicate) {
        Validate.notNull((Object)this.getCategory(categoryName), (String)"Category %s not found", (Object[])new Object[]{categoryName});
        this.getProcessors().stream().filter(adapter -> (processorType == null || processorType == adapter.getType()) && !(adapter instanceof EventSetProcessorAdapterGroup)).filter(adapter -> predicate.test(adapter.getProcessor())).forEach(adapter -> adapter.getMeta().setCategory(categoryName));
    }

    public void selectCategory(String categoryName, ProcessorPredicate predicate) {
        this.selectCategory(categoryName, null, predicate);
    }

    public ActionMeta getActionMeta(String actionName) {
        ActionAdapter adapter = this.getActionManager().getActionAdapter(actionName);
        Validate.isTrue((adapter != null ? 1 : 0) != 0, (String)"Action %s not found", (Object[])new Object[]{actionName});
        return adapter.getMeta();
    }

    public FilterMeta getFilterMeta(String filterName) {
        FilterAdapter adapter = (FilterAdapter)this.getFilterProcessingUnit().getRegisteredProcessorAdapterMap().get(filterName);
        Validate.isTrue((adapter != null ? 1 : 0) != 0, (String)"Filter %s not found", (Object[])new Object[]{filterName});
        return adapter.getMeta();
    }

    public TriggerMeta getTriggerMeta(String triggerName) {
        EventProcessorAdapter adapter = (EventProcessorAdapter)this.getMainProcessingUnit().getRegisteredProcessorAdapterMap().get(triggerName);
        Validate.isTrue((adapter != null ? 1 : 0) != 0, (String)"Trigger %s not found", (Object[])new Object[]{adapter});
        Validate.isTrue((adapter.getType() == ProcessorType.TRIGGER ? 1 : 0) != 0, (String)"Processor %s is not a trigger", (Object[])new Object[]{triggerName});
        return (TriggerMeta)adapter.getMeta();
    }

    public CorrelatorMeta getCorrelatorMeta(String correlatorName) {
        EventProcessorAdapter adapter = (EventProcessorAdapter)this.getMainProcessingUnit().getRegisteredProcessorAdapterMap().get(correlatorName);
        Validate.isTrue((adapter != null ? 1 : 0) != 0, (String)"Correlator %s not found", (Object[])new Object[]{adapter});
        Validate.isTrue((adapter.getType() == ProcessorType.CORRELATOR_GROUP ? 1 : 0) != 0, (String)"Processor %s is not a correlator", (Object[])new Object[]{correlatorName});
        return (CorrelatorMeta)adapter.getMeta();
    }

    public RuleMeta getRuleMeta(String ruleName) {
        EventProcessorAdapter adapter = (EventProcessorAdapter)this.getMainProcessingUnit().getRegisteredProcessorAdapterMap().get(ruleName);
        Validate.isTrue((adapter != null ? 1 : 0) != 0, (String)"Rule %s not found", (Object[])new Object[]{adapter});
        Validate.isTrue((adapter.getType() == ProcessorType.RULE_GROUP ? 1 : 0) != 0, (String)"Processor %s is not a rule", (Object[])new Object[]{ruleName});
        return (RuleMeta)adapter.getMeta();
    }

    public <T extends DataType<?>> void addType(String registeredTypeName, DataTypeSupplier<T> typeSupplier) {
        Validate.notNull(typeSupplier, (String)"The supplier for type %s is null", (Object[])new Object[]{registeredTypeName});
        DataType prototype = typeSupplier.supply();
        Validate.notNull((Object)prototype, (String)"The supplied type %s is null", (Object[])new Object[]{registeredTypeName});
        SpongeUtils.validateType(prototype, registeredTypeName);
        SpongeUtils.setupType(prototype);
        this.types.put(registeredTypeName, typeSupplier);
    }

    public <T extends DataType<?>> T getType(String registeredTypeName) {
        DataTypeSupplier supplier = (DataTypeSupplier)Validate.notNull((Object)this.types.get(registeredTypeName), (String)"Type %s is not registered", (Object[])new Object[]{registeredTypeName});
        DataType type = (DataType)Validate.notNull((Object)supplier.supply(), (String)"The supplied type %s is null", (Object[])new Object[]{registeredTypeName});
        return (T)this.setupRegisteredTypeInstance(registeredTypeName, type);
    }

    public <T extends DataType<?>> T getType(String registeredTypeName, String locationName) {
        T type = this.getType(registeredTypeName);
        type.setName(locationName);
        return type;
    }

    protected <T extends DataType<?>> T setupRegisteredTypeInstance(String registeredTypeName, T type) {
        type.setRegisteredType(registeredTypeName);
        SpongeUtils.setupType(type);
        return type;
    }

    public Map<String, DataType> getTypes() {
        return SpongeApiUtils.collectToLinkedMap(this.types, entry -> (String)entry.getKey(), entry -> this.setupRegisteredTypeInstance((String)entry.getKey(), ((DataTypeSupplier)entry.getValue()).supply()));
    }

    public boolean hasType(String registeredTypeName) {
        return this.types.containsKey(registeredTypeName);
    }

    public boolean removeType(String registeredTypeName) {
        return this.types.remove(registeredTypeName) != null;
    }

    public void addEventType(String eventTypeName, RecordType dataType) {
        this.eventTypes.put(eventTypeName, dataType);
    }

    public RecordType getEventType(String eventTypeName) {
        return (RecordType)Validate.notNull((Object)this.eventTypes.get(eventTypeName), (String)"Event type %s is not registered", (Object[])new Object[]{eventTypeName});
    }

    public boolean hasEventType(String eventTypeName) {
        return this.eventTypes.containsKey(eventTypeName);
    }

    public Map<String, RecordType> getEventTypes() {
        return Collections.unmodifiableMap(this.eventTypes);
    }

    public boolean removeEventType(String eventTypeName) {
        return this.eventTypes.remove(eventTypeName) != null;
    }
}

