/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.event;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openksavi.sponge.core.engine.event.BaseEventQueue;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.Event;

public class SynchroEventQueue
extends BaseEventQueue {
    private LinkedBlockingQueue<Event> queue;
    private Lock lock = new ReentrantLock(true);

    public SynchroEventQueue(String name) {
        super(name);
    }

    @Override
    public void doStartup() {
        this.queue = this.capacity >= 0 ? new LinkedBlockingQueue(this.getCapacity()) : new LinkedBlockingQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(Event event) {
        this.lock.lock();
        try {
            boolean success = false;
            while (!success) {
                try {
                    this.queue.add(event);
                    success = true;
                }
                catch (IllegalStateException e) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.getEngine().getDefaultParameters().getInternalQueueBlockingPutSleep());
                    }
                    catch (InterruptedException ie) {
                        throw SpongeUtils.wrapException(ie);
                        return;
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Event get(long timeout) throws InterruptedException {
        return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public int getSize() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
    }
}

