/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.event;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;

public abstract class BaseEvent
implements Event {
    private static final long serialVersionUID = -2269323477538266057L;
    public static final int DEFAULT_PRIORITY = 0;
    protected String id;
    protected Instant time;
    protected String name;
    protected EventClonePolicy clonePolicy;
    protected String label;
    protected String description;

    protected BaseEvent(String name, EventClonePolicy clonePolicy) {
        if (name == null) {
            throw new IllegalArgumentException("Event name cannot be null");
        }
        this.name = name;
        this.clonePolicy = clonePolicy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPriority() {
        return 0;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected abstract <T> T doGet(String var1, boolean var2, T var3);

    protected final <T> T getDefaultAttributeValue(String name, boolean useDefault, T defaultValue) {
        if (useDefault) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Unknown attribute " + name);
    }

    public final <T> T get(String name) {
        return this.doGet(name, false, null);
    }

    public final <T> T get(Class<T> cls, String name) {
        return this.doGet(name, false, null);
    }

    public final <T> T get(String name, T defaultValue) {
        return this.doGet(name, true, defaultValue);
    }

    public Event set(Map<String, Object> attributes) {
        if (attributes != null) {
            attributes.forEach((name, value) -> this.validateAttribute((String)name, value));
            attributes.forEach((name, value) -> this.set((String)name, value));
        }
        return this;
    }

    public boolean equalsById(Event event) {
        return event != null && Objects.equals(this.id, event.getId());
    }

    public boolean equalsByAttributes(Event event) {
        if (event == null) {
            return false;
        }
        if (event == this) {
            return true;
        }
        return Objects.equals(this.name, event.getName()) && this.getAll().equals(event.getAll());
    }

    protected void validateAttribute(String name, Object value) {
        if (this.clonePolicy == EventClonePolicy.DEEP && !(value instanceof Serializable)) {
            throw new SpongeException("Not serializable attribute can't be deep cloned.");
        }
    }

    public BaseEvent clone() {
        try {
            return (BaseEvent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    protected final String toStringBase() {
        return this.name + ", id=" + this.id + ", time=" + this.time + ", priority=" + this.getPriority();
    }

    public String toString() {
        return this.toStringBase() + ", attributes=" + this.getAll();
    }
}

