/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.io.FileLocatorUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.awaitility.Awaitility;
import org.awaitility.Duration;
import org.awaitility.core.ConditionTimeoutException;
import org.openksavi.sponge.CategoryMeta;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorOperations;
import org.openksavi.sponge.ProcessorQualifiedName;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.engine.EngineConstants;
import org.openksavi.sponge.core.event.EventId;
import org.openksavi.sponge.core.rule.BaseRule;
import org.openksavi.sponge.core.util.LocalCacheBuilder;
import org.openksavi.sponge.core.util.SslConfiguration;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.engine.WrappedException;
import org.openksavi.sponge.event.ControlEvent;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.shaded.com.google.common.base.CaseFormat;
import org.openksavi.sponge.shaded.com.google.common.base.Splitter;
import org.openksavi.sponge.shaded.com.google.common.collect.ImmutableSet;
import org.openksavi.sponge.shaded.com.google.common.collect.Lists;
import org.openksavi.sponge.shaded.com.google.common.collect.Streams;
import org.openksavi.sponge.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.openksavi.sponge.type.AnyType;
import org.openksavi.sponge.type.BinaryType;
import org.openksavi.sponge.type.BooleanType;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.DateTimeType;
import org.openksavi.sponge.type.DynamicType;
import org.openksavi.sponge.type.IntegerType;
import org.openksavi.sponge.type.ListType;
import org.openksavi.sponge.type.MapType;
import org.openksavi.sponge.type.NumberType;
import org.openksavi.sponge.type.ObjectType;
import org.openksavi.sponge.type.RecordType;
import org.openksavi.sponge.type.StreamType;
import org.openksavi.sponge.type.StringType;
import org.openksavi.sponge.type.TypeType;
import org.openksavi.sponge.type.VoidType;
import org.openksavi.sponge.util.DataTypeUtils;
import org.openksavi.sponge.util.Descriptive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpongeUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpongeUtils.class);
    public static final String TAG_SECURITY_KEY_STORE_PASSWORD = "keyStorePassword";
    public static final String TAG_SECURITY_KEY_PASSWORD = "keyPassword";
    public static final String TAG_SECURITY_KEY_STORE = "keyStore";
    public static final String TAG_SECURITY_ALGORITHM = "algorithm";
    private static final List<Class<? extends DataType>> SUPPORTED_TYPES = Arrays.asList(AnyType.class, BinaryType.class, BooleanType.class, DateTimeType.class, DynamicType.class, IntegerType.class, ListType.class, MapType.class, NumberType.class, ObjectType.class, RecordType.class, StreamType.class, StringType.class, TypeType.class, VoidType.class);

    protected SpongeUtils() {
    }

    public static <T> T createInstance(String className, Class<T> javaClass) {
        try {
            return (T)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    public static Object invokeMethod(Object target, String name, Object ... args) {
        try {
            return MethodUtils.invokeMethod((Object)target, (String)name, (Object[])args);
        }
        catch (InvocationTargetException e) {
            throw new SpongeException(e.getTargetException());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    public static <T extends Serializable> T deepClone(T source) {
        return (T)SerializationUtils.clone(source);
    }

    public static Reader getReader(String filename) {
        return SpongeUtils.getReader(filename, Charset.defaultCharset());
    }

    public static Reader getReader(String filename, Charset charset) {
        InputStream is = SpongeUtils.getInputStream(filename);
        return is != null ? new InputStreamReader(is, charset) : null;
    }

    public static InputStream getInputStream(String filename) {
        try {
            if (Files.isRegularFile(Paths.get(filename, new String[0]), new LinkOption[0])) {
                return Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
            }
            URL url = SpongeUtils.getUrlFromClasspath(filename);
            if (url != null) {
                return url.openStream();
            }
            return null;
        }
        catch (IOException e) {
            throw new SpongeException("Error reading " + filename, (Throwable)e);
        }
    }

    public static URL getUrlFromClasspath(String resourceName) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        return url;
    }

    public static String dumpConfiguration(Configuration configuration) {
        StringWriter sw = new StringWriter();
        ConfigurationUtils.dump((Configuration)configuration, (PrintWriter)new PrintWriter(sw));
        return sw.toString();
    }

    public static Object searchConfigurationValueByAttributeValue(org.openksavi.sponge.config.Configuration root, String parentKey, String attrName, String attrValue) {
        return root.getChildConfigurationsOf(parentKey).stream().filter(configuration -> Objects.equals(configuration.getAttribute(attrName, null), attrValue)).map(org.openksavi.sponge.config.Configuration::getValue).findFirst().orElse(null);
    }

    public static Thread executeConcurrentlyOnce(SpongeEngine engine, Runnable runnable, String name) {
        Thread thread = new Thread(runnable, "executeConcurrentlyOnce-" + name);
        thread.start();
        return thread;
    }

    public static String createGlobalLoggerName(KnowledgeBaseEngineOperations knowledgeBaseEngineOperations) {
        if (knowledgeBaseEngineOperations != null && knowledgeBaseEngineOperations.getKnowledgeBase() != null) {
            return SpongeUtils.createLoggerName(knowledgeBaseEngineOperations.getKnowledgeBase(), "global");
        }
        return "sponge.kb.global";
    }

    public static String createPluginLoggerName() {
        return "sponge.kb.plugin";
    }

    public static String createLoggerName(KnowledgeBase knowledgeBase, String targetName) {
        return "sponge.kb." + knowledgeBase.getType().getTypeCode() + "." + knowledgeBase.getName() + "." + targetName;
    }

    public static String createNonScriptKnowledgeBaseName(KnowledgeBase knowledgeBase) {
        return knowledgeBase.getClass().getSimpleName();
    }

    public static void shutdownExecutorService(Object named, ExecutorService executorService, long timeout) {
        MoreExecutors.shutdownAndAwaitTermination(executorService, timeout, TimeUnit.MILLISECONDS);
        if (!executorService.isTerminated()) {
            logger.warn("Executor for {} hasn't shutdown gracefully.", named);
        }
    }

    public static void shutdownExecutorService(SpongeEngine engine, Object named, ExecutorService executorService) {
        SpongeUtils.shutdownExecutorService(named, executorService, engine.getDefaultParameters().getExecutorShutdownTimeout());
    }

    public static ScriptKnowledgeBaseInterpreter getScriptInterpreter(SpongeEngine engine, String kbName) {
        return engine.getKnowledgeBaseManager().getScriptKnowledgeBase(kbName).getInterpreter();
    }

    public static KnowledgeBaseEngineOperations getSponge(KnowledgeBaseInterpreter interpreter) {
        return (KnowledgeBaseEngineOperations)interpreter.getVariable("sponge", KnowledgeBaseEngineOperations.class);
    }

    public static String getAbbreviatedEventSequenceString(BaseRule rule) {
        return "[" + rule.getEventSequence().stream().map(event -> event != null ? event.getName() + "/" + event.getId() : "<none>").collect(Collectors.joining(", ")) + "]";
    }

    private static SpongeException doWrapException(String sourceName, KnowledgeBaseInterpreter interpreter, Throwable throwable) {
        String specificErrorMessage;
        if (throwable instanceof SpongeException) {
            return (SpongeException)throwable;
        }
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        String string = specificErrorMessage = interpreter != null ? interpreter.getSpecificExceptionMessage(throwable) : null;
        if (sourceName == null) {
            return specificErrorMessage == null ? new SpongeException(throwable) : new SpongeException(specificErrorMessage, throwable);
        }
        return specificErrorMessage == null ? new WrappedException(sourceName, throwable) : new WrappedException(sourceName, specificErrorMessage, throwable);
    }

    public static SpongeException wrapException(Throwable throwable) {
        return SpongeUtils.doWrapException(null, null, throwable);
    }

    public static SpongeException wrapException(String sourceName, Throwable throwable) {
        return SpongeUtils.doWrapException(sourceName, null, throwable);
    }

    public static SpongeException wrapException(Processor<?> processor, Throwable throwable) {
        return SpongeUtils.doWrapException(SpongeUtils.getProcessorQualifiedName(processor).toString(), processor.getKnowledgeBase().getInterpreter(), throwable);
    }

    public static SpongeException wrapException(KnowledgeBaseInterpreter interpreter, Throwable throwable) {
        return SpongeUtils.doWrapException(null, interpreter, throwable);
    }

    public static SpongeException wrapException(String sourceName, KnowledgeBaseInterpreter interpreter, Throwable throwable) {
        return SpongeUtils.doWrapException(sourceName, interpreter, throwable);
    }

    public static SpongeException wrapInvokeException(Object target, String method, KnowledgeBaseInterpreter interpreter, Throwable throwable) {
        String sourceName = (target instanceof ProcessorOperations ? SpongeUtils.getProcessorQualifiedName((ProcessorOperations)target) : target) + "." + method;
        return SpongeUtils.doWrapException(sourceName, interpreter, throwable);
    }

    public static boolean containsException(Throwable exception, Class<?> type) {
        return ExceptionUtils.indexOfType((Throwable)exception, type) > -1;
    }

    public static <T> T getException(Throwable exception, Class<T> type) {
        return (T)ExceptionUtils.getThrowableList((Throwable)exception).get(ExceptionUtils.indexOfType((Throwable)exception, type));
    }

    public static String getSourceName(Throwable exception) {
        return exception instanceof WrappedException ? ((WrappedException)exception).getSourceName() : null;
    }

    public static String toStringEventSequence(Collection<Event> events) {
        return SpongeUtils.toStringEventSequence(events, null);
    }

    public static String toStringEventSequence(Collection<Event> events, String attributeName) {
        return events.stream().map(event -> event != null ? event.getName() + "(" + EventId.fromString(event.getId()).getId() + ")" + (attributeName != null ? "/" + event.get(attributeName) : "") : "null").collect(Collectors.joining(", "));
    }

    public static String toStringArrayEventSequence(Collection<Event> events, String attributeName) {
        return "{ " + events.stream().map(event -> event != null ? "\"" + event.get(attributeName) + "\"" : "null").collect(Collectors.joining(", ")) + " }";
    }

    public static String createControlEventName(Class<? extends ControlEvent> controlEventClass) {
        return "$" + StringUtils.uncapitalize((String)controlEventClass.getSimpleName());
    }

    public static int calculateInitialDynamicThreadPoolSize(SpongeEngine engine, int maxPoolSize) {
        int result = (int)Math.round(engine.getDefaultParameters().getInitialDynamicThreadPoolSizeRatio() * (double)maxPoolSize);
        if (result < 1) {
            result = 1;
        }
        return result;
    }

    public static String getPackagePath(Class<?> cls) {
        return cls.getPackage().getName().replace('.', '/');
    }

    public static String getLastSubdirectory(String dir) {
        try {
            List subdirs = Files.list(Paths.get(dir, new String[0])).map(path -> path.getFileName().toFile().getName()).sorted().collect(Collectors.toList());
            return subdirs.size() > 0 ? (String)subdirs.get(subdirs.size() - 1) : null;
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static <E> Set<E> immutableSetOf(E e) {
        return ImmutableSet.of(e);
    }

    public static <E> Set<E> immutableSetOf(E e1, E e2) {
        return ImmutableSet.of(e1, e2);
    }

    public static <E> Set<E> immutableSetOf(E e1, E e2, E e3) {
        return ImmutableSet.of(e1, e2, e3);
    }

    public static <E> Set<E> immutableSetOf(E e1, E e2, E e3, E e4) {
        return ImmutableSet.of(e1, e2, e3, e4);
    }

    public static <E> Set<E> immutableSetOf(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSet.of(e1, e2, e3, e4, e5);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> immutableMapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return Collections.unmodifiableMap(map);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return Streams.stream(iterator);
    }

    public static List<String> split(String text, char separator) {
        return Splitter.on(separator).trimResults().omitEmptyStrings().splitToList(text);
    }

    public static void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static void close(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static void closeQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Throwable e) {
            logger.warn("Error closing a reader", e);
        }
    }

    public static String getRequiredConfigurationString(org.openksavi.sponge.config.Configuration configuration, String key) {
        String value = configuration.getString(key, null);
        if (value == null) {
            throw new IllegalArgumentException("A required configuration parameter '" + key + "' is not set");
        }
        return value;
    }

    public static int toInt(Object value) {
        return ((Number)value).intValue();
    }

    public static void registerShutdownHook(SpongeEngine engine) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                engine.shutdown();
            }
            catch (Throwable e) {
                logger.error("Shutdown hook error", e);
            }
        }));
    }

    public static String toUpperCamelCaseFromUnderscore(String s) {
        return s != null ? CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, s.toLowerCase()) : null;
    }

    public static boolean isAbstract(Class<?> cls) {
        return Modifier.isAbstract(cls.getModifiers());
    }

    public static boolean awaitUntil(Callable<Boolean> callable, long timeout, TimeUnit unit) {
        try {
            Awaitility.await().atMost(timeout, unit).until(callable);
            return true;
        }
        catch (ConditionTimeoutException e) {
            return false;
        }
    }

    public static boolean awaitUntil(Callable<Boolean> callable) {
        try {
            Awaitility.await().atMost(Duration.FOREVER).until(callable);
            return true;
        }
        catch (ConditionTimeoutException e) {
            return false;
        }
    }

    public static boolean isSystemEvent(Event event) {
        return EngineConstants.PREDEFINED_EVENT_NAMES.contains(event.getName());
    }

    public static List<ProcessorQualifiedName> getProcessorQualifiedNameList(String processorQualifiedNamesSpec) {
        if (processorQualifiedNamesSpec == null) {
            return new ArrayList<ProcessorQualifiedName>();
        }
        return Arrays.stream(processorQualifiedNamesSpec.split(",")).map(String::trim).map(element -> {
            String[] spec = element.split(":");
            String knowledgeBaseName = spec[0].trim();
            String name = spec.length > 1 ? spec[1].trim() : "";
            return new ProcessorQualifiedName(!knowledgeBaseName.isEmpty() ? knowledgeBaseName : ".*", !name.isEmpty() ? name : ".*");
        }).collect(Collectors.toList());
    }

    public static List<String> getNameList(String namesSpec) {
        if (namesSpec == null) {
            return Lists.newArrayList(".*");
        }
        return Arrays.stream(namesSpec.split(",")).map(String::trim).collect(Collectors.toList());
    }

    protected static KeyStore getKeyStoreInstance() {
        try {
            return KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static KeyManagerFactory createKeyManagerFactory(KeyStore ks, SslConfiguration sslConfiguration) {
        InputStream fis = null;
        try {
            fis = SpongeUtils.getInputStream(sslConfiguration.getKeyStore());
            if (fis == null) {
                throw new SpongeException("Expected a '" + sslConfiguration.getKeyStore() + "' keystore file on the classpath");
            }
            ks.load(fis, sslConfiguration.getKeyStorePassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(sslConfiguration.getAlgorithm());
            kmf.init(ks, sslConfiguration.getKeyPassword().toCharArray());
            KeyManagerFactory keyManagerFactory = kmf;
            return keyManagerFactory;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw SpongeUtils.wrapException(e);
        }
        finally {
            SpongeUtils.close(fis);
        }
    }

    public static KeyManagerFactory createKeyManagerFactory(SslConfiguration sslConfiguration) {
        return SpongeUtils.createKeyManagerFactory(SpongeUtils.getKeyStoreInstance(), sslConfiguration);
    }

    public static SSLContext createSslContext(SslConfiguration sslConfiguration) {
        try {
            KeyStore ks = SpongeUtils.getKeyStoreInstance();
            KeyManagerFactory kmf = SpongeUtils.createKeyManagerFactory(ks, sslConfiguration);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(sslConfiguration.getAlgorithm());
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static SslConfiguration createSslConfiguration(org.openksavi.sponge.config.Configuration configuration) {
        SslConfiguration sslConfiguration = new SslConfiguration();
        sslConfiguration.setKeyStore(SpongeUtils.getRequiredConfigurationString(configuration, TAG_SECURITY_KEY_STORE));
        sslConfiguration.setKeyStorePassword(SpongeUtils.getRequiredConfigurationString(configuration, TAG_SECURITY_KEY_STORE_PASSWORD));
        sslConfiguration.setKeyPassword(SpongeUtils.getRequiredConfigurationString(configuration, TAG_SECURITY_KEY_PASSWORD));
        sslConfiguration.setAlgorithm(configuration.getString(TAG_SECURITY_ALGORITHM, "SunX509"));
        return sslConfiguration;
    }

    public static ProcessorQualifiedName getProcessorQualifiedName(ProcessorOperations processorOperations) {
        return new ProcessorQualifiedName(processorOperations.getKnowledgeBase() != null ? processorOperations.getKnowledgeBase().getName() : null, processorOperations.getMeta().getName());
    }

    public static Class<?> getClass(String className) {
        try {
            return ClassUtils.getClass((String)className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void doInWrappedException(KnowledgeBase knowledgeBase, Runnable runnable, String sourceName) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(sourceName, knowledgeBase.getInterpreter(), e);
        }
    }

    public static void validateType(DataType type, String valueName) {
        SpongeUtils.doValidateType(type, valueName, new LinkedList<DataType>());
    }

    protected static void doValidateType(DataType type, String valueName, Deque<DataType> stack) {
        if (type.getName() != null) {
            Validate.isTrue((!type.getName().trim().isEmpty() && !StringUtils.containsWhitespace((CharSequence)type.getName()) && !StringUtils.containsAny((CharSequence)type.getName(), (CharSequence)".") ? 1 : 0) != 0, (String)"Invalid type name '%s' in the %s", (Object[])new Object[]{type.getName(), valueName});
        }
        Validate.isTrue((!stack.stream().anyMatch(ancestorType -> ancestorType == type) ? 1 : 0) != 0, (String)"A loop in the type specification has been found in the %s", (Object[])new Object[]{valueName});
        if (type.getProvided() != null) {
            Validate.isTrue((!type.getProvided().isElementValueSet() || DataTypeUtils.supportsElementValueSet((DataType)type) ? 1 : 0) != 0, (String)"Element value set is applicable only for list types in the %s", (Object[])new Object[]{valueName});
        }
        stack.push(type);
        switch (type.getKind()) {
            case OBJECT: {
                Validate.isInstanceOf(ObjectType.class, (Object)type, (String)"The type should be an instance of %s", (Object[])new Object[]{ObjectType.class});
                String className = ((ObjectType)type).getClassName();
                Validate.notNull((Object)className, (String)"Missing class name in the %s", (Object[])new Object[]{valueName});
                Validate.notNull(SpongeUtils.getClass(className), (String)"The class %s used in the %s not found", (Object[])new Object[]{className, valueName});
                break;
            }
            case LIST: {
                Validate.isInstanceOf(ListType.class, (Object)type, (String)"The type should be an instance of %s", (Object[])new Object[]{ListType.class});
                SpongeUtils.doValidateType((DataType)Validate.notNull((Object)((ListType)type).getElementType(), (String)"List element type not specified in the %s", (Object[])new Object[]{valueName}), valueName, stack);
                break;
            }
            case MAP: {
                Validate.isInstanceOf(MapType.class, (Object)type, (String)"The type should be an instance of %s", (Object[])new Object[]{MapType.class});
                SpongeUtils.doValidateType((DataType)Validate.notNull((Object)((MapType)type).getKeyType(), (String)"Map key type not specified in the %s", (Object[])new Object[]{valueName}), valueName, stack);
                SpongeUtils.doValidateType((DataType)Validate.notNull((Object)((MapType)type).getValueType(), (String)"Map value type not specified in the %s", (Object[])new Object[]{valueName}), valueName, stack);
                break;
            }
            case RECORD: {
                Validate.isInstanceOf(RecordType.class, (Object)type, (String)"The type should be an instance of %s", (Object[])new Object[]{RecordType.class});
                Validate.isTrue((((RecordType)type).getFields() != null && !((RecordType)type).getFields().isEmpty() ? 1 : 0) != 0, (String)"The record type must define fields", (Object[])new Object[0]);
                ((RecordType)type).getFields().forEach(field -> {
                    Validate.notNull((Object)field, (String)"Record field type not specified in the %s", (Object[])new Object[]{valueName});
                    SpongeUtils.validateRecordFieldName(field.getName(), valueName);
                    SpongeUtils.doValidateType(field, valueName, stack);
                });
                break;
            }
        }
        stack.pop();
    }

    public static void setupType(DataType type) {
        if (type instanceof RecordType) {
            SpongeUtils.mergeInheritedRecordType((RecordType)type);
        }
    }

    public static void mergeInheritedRecordType(RecordType type) {
        RecordType baseType = type.getBaseType();
        if (baseType == null || type.isInheritationApplied()) {
            return;
        }
        SpongeUtils.mergeTypes((DataType)baseType, (DataType)type);
        ArrayList mergedFields = new ArrayList(baseType.getFields());
        type.getFields().forEach(subTypeField -> {
            Validate.isTrue((!mergedFields.stream().anyMatch(mergedField -> Objects.equals(mergedField.getName(), subTypeField.getName())) ? 1 : 0) != 0, (String)"The field '%s' has already been defined in the base type", (Object[])new Object[]{subTypeField.getName()});
            mergedFields.add(subTypeField);
        });
        type.setFields(mergedFields);
        type.setInheritationApplied(true);
    }

    protected static void mergeTypes(DataType baseType, DataType subType) {
        Validate.isTrue((boolean)Objects.equals(baseType.getKind(), subType.getKind()), (String)"The types to be merged %s and %s are incompatible", (Object[])new Object[]{baseType.getKind(), subType.getKind()});
        if (subType.getName() == null) {
            subType.setName(baseType.getName());
        }
        if (subType.getLabel() == null) {
            subType.setLabel(baseType.getLabel());
        }
        if (subType.getDescription() == null) {
            subType.setDescription(baseType.getDescription());
        }
        if (!subType.isAnnotated()) {
            subType.setAnnotated(baseType.isAnnotated());
        }
        if (subType.getFormat() == null) {
            subType.setFormat(baseType.getFormat());
        }
        if (subType.getDefaultValue() == null) {
            subType.setDefaultValue(baseType.getDefaultValue());
        }
        if (!subType.isNullable()) {
            subType.setNullable(baseType.isNullable());
        }
        LinkedHashMap mergedFeatures = new LinkedHashMap(baseType.getFeatures());
        mergedFeatures.putAll(subType.getFeatures());
        subType.setFeatures(mergedFeatures);
        if (!subType.isOptional()) {
            subType.setOptional(baseType.isOptional());
        }
        if (subType.getProvided() == null) {
            subType.setProvided(baseType.getProvided());
        }
    }

    public static List<Class<? extends DataType>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    public static String getConfigurationFileDir(SpongeEngine engine) {
        return SpongeUtils.getFileDir(engine.getConfigurationManager().getConfigurationFileUrl());
    }

    public static String getFileDir(URL fileUrl) {
        if (fileUrl != null) {
            File configFile = FileLocatorUtils.fileFromURL((URL)fileUrl);
            if (configFile != null) {
                return configFile.getParent();
            }
            logger.warn("URL {} cannot be converted to File", (Object)fileUrl);
        }
        return null;
    }

    public static File getFileDirAsFile(String filePath) {
        return FileUtils.getFile((String[])new String[]{filePath}).getParentFile();
    }

    public static LocalCacheBuilder cacheBuilder() {
        return new LocalCacheBuilder();
    }

    public static String getRandomUuidString() {
        return UUID.randomUUID().toString();
    }

    public static byte[] readFileToByteArray(String filename) {
        try {
            return FileUtils.readFileToByteArray((File)new File(filename));
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static void writeByteArrayToFile(byte[] bytes, String filename) {
        try {
            FileUtils.writeByteArrayToFile((File)new File(filename), (byte[])(bytes != null ? bytes : new byte[]{}));
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(e);
        }
    }

    public static <T> List<T> createUnmodifiableList(List<T> source) {
        return source != null ? Collections.unmodifiableList(new ArrayList<T>(source)) : null;
    }

    public static <K, V> Map<K, V> createUnmodifiableMap(Map<K, V> source) {
        return source != null ? Collections.unmodifiableMap(new LinkedHashMap<K, V>(source)) : null;
    }

    public static void validateEventName(String name) {
        Validate.isTrue((name != null && !name.trim().isEmpty() ? 1 : 0) != 0, (String)"Event name must not be null or empty", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.containsWhitespace((CharSequence)name) && !StringUtils.containsAny((CharSequence)name, (CharSequence)":") ? 1 : 0) != 0, (String)"Event name must not contain whitespaces or reserved characters %s", (Object[])new Object[]{":"});
    }

    public static void validateRecordFieldName(String name, String valueName) {
        Validate.isTrue((name != null && !name.trim().isEmpty() ? 1 : 0) != 0, (String)"Record field name not specified in the %s", (Object[])new Object[]{valueName});
        Validate.isTrue((!StringUtils.containsWhitespace((CharSequence)name) && !StringUtils.containsAny((CharSequence)name, (CharSequence)".") ? 1 : 0) != 0, (String)"The record field name is invalid in the %s", (Object[])new Object[]{valueName});
    }

    public static int getKnowledgeBaseIndex(SpongeEngine engine, KnowledgeBase kb) {
        return engine.getKnowledgeBaseManager().getKnowledgeBases().indexOf(kb);
    }

    public static int getCategoryIndex(SpongeEngine engine, CategoryMeta category) {
        return engine.getCategories().indexOf(category);
    }

    public static String getDisplayLabel(Descriptive descriptive) {
        return descriptive != null ? (descriptive.getLabel() != null ? descriptive.getLabel() : descriptive.getName()) : null;
    }
}

