/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.EventSetProcessorAdapterGroup;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.processing.decomposed.DecomposedQueue;
import org.openksavi.sponge.core.engine.processing.decomposed.DecomposedQueueMainProcessingUnit;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.engine.StatisticsManager;
import org.openksavi.sponge.engine.ThreadPool;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.engine.processing.MainProcessingUnit;

public class DefaultStatisticsManager
extends BaseEngineModule
implements StatisticsManager {
    private AtomicReference<Instant> timeMeasurementStart = new AtomicReference<Object>(null);
    private AtomicLong timeMeasurementEventCount = new AtomicLong(0L);

    public DefaultStatisticsManager(SpongeEngine engine) {
        super("StatisticsManager", engine);
    }

    public int getScheduledEventCount() {
        return this.getEngine().getEventScheduler().getEntries().size();
    }

    public int getActiveThreadCount() {
        return Thread.activeCount();
    }

    public int getPluginCount() {
        return this.getEngine().getPluginManager().getPlugins().size();
    }

    private String getQueueSummary(EventQueue queue) {
        return queue.getName() + " (capacity=" + queue.getCapacity() + "; size=" + queue.getSize() + ")";
    }

    protected String getEventSetProcessorsSummary(String label, List<? extends EventSetProcessorAdapterGroup> groups) {
        return label + "(" + groups.size() + ")" + (groups.isEmpty() ? "" : ": ") + groups.stream().map(group -> String.format("%s (%s)", group.getMeta().getName(), group.getEventSetProcessorAdapters().size())).collect(Collectors.joining(", "));
    }

    protected String getThreadPoolSummary(ThreadPool threadPool) {
        StringBuffer sb = new StringBuffer(512);
        sb.append(threadPool.getName());
        if (threadPool.getExecutor() instanceof ThreadPoolExecutor) {
            sb.append(" (");
            ThreadPoolExecutor executor = (ThreadPoolExecutor)threadPool.getExecutor();
            sb.append("max=" + executor.getMaximumPoolSize());
            sb.append(", current=" + executor.getPoolSize());
            sb.append(", active=" + executor.getActiveCount());
            sb.append(", largest=" + executor.getLargestPoolSize());
            sb.append(", core=" + executor.getCorePoolSize());
            sb.append(", all tasks=" + executor.getTaskCount());
            sb.append(", completed tasks=" + executor.getCompletedTaskCount());
            sb.append(", queue size=" + executor.getQueue().size());
            sb.append(", queue remaining capacity=" + executor.getQueue().remainingCapacity());
            sb.append(")");
        }
        return sb.toString();
    }

    public Double getEventPerformance() {
        Instant start = this.timeMeasurementStart.get();
        long events = this.timeMeasurementEventCount.get();
        if (start == null || events == 0L) {
            return null;
        }
        return (double)events / (double)Duration.between(start, Instant.now()).toMillis() * 1000.0;
    }

    public String getMemorySummary() {
        return String.format("Memory (total=%s, used=%s)", FileUtils.byteCountToDisplaySize((long)Runtime.getRuntime().totalMemory()), FileUtils.byteCountToDisplaySize((long)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())));
    }

    public String getDecomposedQueueSummary(DecomposedQueueMainProcessingUnit mainProcessingUnit) {
        DecomposedQueue<EventProcessorAdapter<?>> queue = mainProcessingUnit.getDecomposedQueue();
        return String.format("Decomposed queue (capacity=%s, size=%s)", queue.getCapacity(), queue.getSize());
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(this.getQueueSummary(this.getEngine().getEventQueueManager().getInputEventQueue()));
        sb.append(". " + this.getQueueSummary(this.getEngine().getEventQueueManager().getMainEventQueue()));
        sb.append(". Plugins (" + this.getPluginCount() + ")");
        sb.append(". Actions (" + this.getEngine().getActions().size() + ")");
        sb.append(". Filters (" + this.getEngine().getFilters().size() + ")");
        sb.append(". Triggers (" + this.getEngine().getTriggers().size() + ")");
        sb.append(". " + this.getEventSetProcessorsSummary("Rules", this.getEngine().getRuleGroups()));
        sb.append(". " + this.getEventSetProcessorsSummary("Correlators", this.getEngine().getCorrelatorGroups()));
        sb.append(". Event scheduler (" + this.getScheduledEventCount() + ")");
        sb.append(". Thread pools: ");
        MainProcessingUnit mainProcessingUnit = this.getEngine().getProcessingUnitManager().getMainProcessingUnit();
        sb.append(this.getThreadPoolSummary(mainProcessingUnit.getWorkerThreadPool()));
        sb.append(", " + this.getThreadPoolSummary(mainProcessingUnit.getAsyncEventSetProcessorThreadPool()));
        if (mainProcessingUnit instanceof DecomposedQueueMainProcessingUnit) {
            sb.append(". " + this.getDecomposedQueueSummary((DecomposedQueueMainProcessingUnit)mainProcessingUnit));
        }
        sb.append(". " + this.getMemorySummary());
        Double eventPerformance = this.getEventPerformance();
        if (eventPerformance != null) {
            sb.append(String.format(". Events performance (%.2f events/s)", eventPerformance));
        }
        sb.append(".");
        return sb.toString();
    }

    public void startTimeMeasurementIfNotStartedYet() {
        this.timeMeasurementStart.compareAndSet(null, Instant.now());
    }

    public void incrementTimeMeasurementEventCount() {
        this.timeMeasurementEventCount.incrementAndGet();
    }

    public void clearTimeMeasurement() {
        this.timeMeasurementStart.set(null);
        this.timeMeasurementEventCount.set(0L);
    }
}

