/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.util.stream.Stream;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.core.BaseEngineOperations;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.correlator.Correlator;
import org.openksavi.sponge.filter.Filter;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;
import org.openksavi.sponge.rule.Rule;
import org.openksavi.sponge.shaded.org.reflections.Reflections;
import org.openksavi.sponge.trigger.Trigger;
import org.slf4j.Logger;

public class BaseKnowledgeBaseEngineOperations
extends BaseEngineOperations
implements KnowledgeBaseEngineOperations {
    protected KnowledgeBase knowledgeBase;

    public BaseKnowledgeBaseEngineOperations(BaseSpongeEngine engine, KnowledgeBase knowledgeBase) {
        super(engine);
        this.knowledgeBase = knowledgeBase;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void enableJava(Class<? extends Processor> processorClass) {
        this.engine.getProcessorManager().enable(this.knowledgeBase, processorClass);
    }

    public void enableJavaAll(Class<?> ... processorClasses) {
        Stream.of(processorClasses).forEachOrdered(processorClass -> this.enableJava((Class<? extends Processor>)processorClass));
    }

    public void enableJavaByScan(Object ... params) {
        Reflections reflections = new Reflections(params);
        reflections.getSubTypesOf(Processor.class).stream().filter(cls -> !SpongeUtils.isAbstract(cls)).forEachOrdered(processorClass -> this.enableJava((Class<? extends Processor>)processorClass));
    }

    public void disableJava(Class<? extends Processor> processorClass) {
        this.engine.getProcessorManager().disable(this.knowledgeBase, processorClass);
    }

    public void disableJavaAll(Class<?> ... processorClasses) {
        Stream.of(processorClasses).forEachOrdered(processorClass -> this.disableJava((Class<? extends Processor>)processorClass));
    }

    public void disableJavaByScan(Object ... params) {
        Reflections reflections = new Reflections(params);
        reflections.getSubTypesOf(Processor.class).stream().filter(cls -> !SpongeUtils.isAbstract(cls)).forEachOrdered(processorClass -> this.disableJava((Class<? extends Processor>)processorClass));
    }

    public void enableJavaFilter(Class<? extends Filter> filterClass) {
        this.engine.getProcessorManager().enableFilter(this.knowledgeBase, filterClass);
    }

    public void disableJavaFilter(Class<? extends Filter> filterClass) {
        this.engine.getProcessorManager().disableFilter(this.knowledgeBase, filterClass);
    }

    public void enableJavaTrigger(Class<? extends Trigger> triggerClass) {
        this.engine.getProcessorManager().enableTrigger(this.knowledgeBase, triggerClass);
    }

    public void disableJavaTrigger(Class<? extends Trigger> triggerClass) {
        this.engine.getProcessorManager().disableTrigger(this.knowledgeBase, triggerClass);
    }

    public void enableJavaRule(Class<? extends Rule> ruleClass) {
        this.engine.getProcessorManager().enableRule(this.knowledgeBase, ruleClass);
    }

    public void disableJavaRule(Class<? extends Rule> ruleClass) {
        this.engine.getProcessorManager().disableRule(this.knowledgeBase, ruleClass);
    }

    public void enableJavaCorrelator(Class<? extends Correlator> correlatorClass) {
        this.engine.getProcessorManager().enableCorrelator(this.knowledgeBase, correlatorClass);
    }

    public void disableJavaCorrelator(Class<? extends Correlator> correlatorClass) {
        this.engine.getProcessorManager().disableCorrelator(this.knowledgeBase, correlatorClass);
    }

    public void enableJavaAction(Class<? extends Action> actionClass) {
        this.engine.getProcessorManager().enableAction(this.knowledgeBase, actionClass);
    }

    public void disableJavaAction(Class<? extends Action> actionClass) {
        this.engine.getProcessorManager().disableAction(this.knowledgeBase, actionClass);
    }

    public KnowledgeBaseInterpreter getInterpreter() {
        return this.knowledgeBase.getInterpreter();
    }

    public KnowledgeBase getKb() {
        return this.getKnowledgeBase();
    }

    public Logger getLogger() {
        return ((BaseKnowledgeBaseInterpreter)this.getKnowledgeBase().getInterpreter()).getLogger();
    }
}

