/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.core.BaseEventSetProcessorMeta;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.RuleEventSpec;
import org.openksavi.sponge.rule.RuleMeta;

public class BaseRuleMeta
extends BaseEventSetProcessorMeta
implements RuleMeta {
    protected boolean ordered = true;
    protected List<RuleEventSpec> eventSpecs;
    protected Map<String, List<EventCondition>> conditions = Collections.synchronizedMap(new LinkedHashMap());

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public List<RuleEventSpec> getEventSpecs() {
        return this.eventSpecs;
    }

    public RuleEventSpec getEventSpec(int index) {
        Validate.isTrue((index >= 0 && index < this.eventSpecs.size() ? 1 : 0) != 0, (String)"Invalid event specification index: %d", (long)index);
        return this.eventSpecs.get(index);
    }

    public void setEventSpecs(List<RuleEventSpec> eventSpecs) {
        this.eventSpecs = new ArrayList<RuleEventSpec>(eventSpecs);
        this.setEventNames(eventSpecs.stream().map(RuleEventSpec::getName).collect(Collectors.toList()));
    }

    public void addEventSpecs(List<RuleEventSpec> eventSpecs) {
        if (this.eventSpecs != null) {
            this.eventSpecs.addAll(eventSpecs);
            this.addEventNames(eventSpecs.stream().map(RuleEventSpec::getName).collect(Collectors.toList()));
        } else {
            this.setEventSpecs(eventSpecs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventConditions(String eventAlias, List<EventCondition> newConditions) {
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            this.safeGetEventConditions(eventAlias).addAll(newConditions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEventCondition(String eventAlias, EventCondition condition) {
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            this.safeGetEventConditions(eventAlias).add(condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllEventConditions(List<EventCondition> newConditions) {
        Validate.isTrue((this.eventSpecs != null && !this.eventSpecs.isEmpty() ? 1 : 0) != 0, (String)"Tring to add conditions to all events when no events have been specified", (Object[])new Object[0]);
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            this.eventSpecs.forEach(spec -> this.addEventConditions(spec.getAlias(), newConditions));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<EventCondition> safeGetEventConditions(String eventAlias) {
        Map<String, List<EventCondition>> map = this.conditions;
        synchronized (map) {
            List<Object> eventConditions = this.conditions.get(eventAlias);
            if (eventConditions == null) {
                eventConditions = Collections.synchronizedList(new ArrayList());
                this.conditions.put(eventAlias, eventConditions);
            }
            return eventConditions;
        }
    }

    public List<EventCondition> getEventConditions(String eventAlias) {
        return this.conditions.get(eventAlias);
    }

    public Map<String, List<EventCondition>> getEventConditions() {
        return this.conditions;
    }
}

