/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openksavi.sponge.core.shaded.com.google.common.util.concurrent.AbstractIdleService;
import org.openksavi.sponge.core.shaded.com.google.common.util.concurrent.Service;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.EngineModule;
import org.openksavi.sponge.engine.SpongeEngine;

public abstract class BaseEngineModule
implements EngineModule {
    private SpongeEngine engine;
    private String name;
    private String label;
    private String description;
    private Service service = new AbstractIdleService(){

        @Override
        protected void startUp() throws Exception {
            BaseEngineModule.this.doStartup();
        }

        @Override
        protected void shutDown() throws Exception {
            BaseEngineModule.this.doShutdown();
        }

        @Override
        protected String serviceName() {
            return BaseEngineModule.this.getClass().getSimpleName();
        }
    };
    private AtomicBoolean afterManualShutdown = new AtomicBoolean(false);
    private Lock lock = new ReentrantLock(true);

    protected BaseEngineModule(String name, SpongeEngine engine) {
        this.name = name;
        this.engine = engine;
    }

    protected BaseEngineModule(String name) {
        this(name, null);
    }

    protected BaseEngineModule() {
    }

    public void setEngine(SpongeEngine engine) {
        this.engine = engine;
    }

    public SpongeEngine getEngine() {
        return this.engine;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    protected void doStartup() {
    }

    protected void doShutdown() {
    }

    public void startup() {
        if (this.isStarting() || this.isRunning()) {
            return;
        }
        this.lock.lock();
        try {
            this.service.startAsync().awaitRunning();
        }
        catch (IllegalStateException e) {
            throw this.isFailed() && e.getCause() != null ? SpongeUtils.wrapException("startup", e.getCause()) : e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shutdown() {
        block12: {
            if (this.isStopping() || this.isTerminated()) {
                return;
            }
            this.lock.lock();
            try {
                if (this.afterManualShutdown.get()) {
                    return;
                }
                if (!this.isFailed()) {
                    try {
                        this.service.stopAsync().awaitTerminated();
                        break block12;
                    }
                    catch (IllegalStateException e) {
                        throw this.isFailed() && e.getCause() != null ? SpongeUtils.wrapException("shutdown", e.getCause()) : e;
                    }
                }
                try {
                    this.doShutdown();
                }
                finally {
                    this.afterManualShutdown.set(true);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public final boolean isNew() {
        return this.service.state() == Service.State.NEW;
    }

    public final boolean isStarting() {
        return this.service.state() == Service.State.STARTING;
    }

    public final boolean isRunning() {
        return this.service.isRunning();
    }

    public final boolean isStopping() {
        return this.service.state() == Service.State.STOPPING;
    }

    public final boolean isTerminated() {
        return this.service.state() == Service.State.TERMINATED;
    }

    public final boolean isFailed() {
        return this.service.state() == Service.State.FAILED;
    }

    public Service.State getState() {
        return this.service.state();
    }

    public Service getInternalService() {
        return this.service;
    }

    public boolean isNewOrStartingOrRunning() {
        return this.isNew() || this.isStarting() || this.isRunning();
    }

    public String toString() {
        return this.name != null ? this.name : this.getClass().getSimpleName();
    }
}

