/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openksavi.sponge.CategoryMeta;
import org.openksavi.sponge.EventSetProcessorState;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.ProvideArgsParameters;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.engine.DefaultProcessorInstanceHolder;
import org.openksavi.sponge.core.engine.EngineConstants;
import org.openksavi.sponge.core.kb.BaseKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.kb.FileKnowledgeBaseScript;
import org.openksavi.sponge.core.kb.ScriptClassInstanceProvider;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ProcessorInstanceHolder;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventClonePolicy;
import org.openksavi.sponge.event.EventName;
import org.openksavi.sponge.features.Features;
import org.openksavi.sponge.features.model.geo.GeoMap;
import org.openksavi.sponge.features.model.geo.GeoMarkerLayer;
import org.openksavi.sponge.features.model.geo.GeoPosition;
import org.openksavi.sponge.features.model.geo.GeoTileLayer;
import org.openksavi.sponge.features.model.ui.IconInfo;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.kb.KnowledgeBaseScript;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.rule.EventMode;
import org.openksavi.sponge.rule.RuleEventSpec;
import org.openksavi.sponge.type.DateTimeKind;
import org.openksavi.sponge.type.provided.ProvidedMeta;
import org.openksavi.sponge.type.provided.ProvidedMode;
import org.openksavi.sponge.type.provided.ProvidedValue;
import org.openksavi.sponge.type.provided.SubmittableMeta;
import org.openksavi.sponge.type.provided.ValueSetMeta;
import org.openksavi.sponge.type.value.AnnotatedValue;
import org.openksavi.sponge.type.value.DynamicValue;
import org.openksavi.sponge.type.value.OutputStreamValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseScriptKnowledgeBaseInterpreter
extends BaseKnowledgeBaseInterpreter
implements ScriptKnowledgeBaseInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(BaseScriptKnowledgeBaseInterpreter.class);
    public static final String PROP_PATH_SEPARATOR = ", \t";
    private Map<Class<?>, Class<?>> processorClasses = new LinkedHashMap(EngineConstants.BASE_PROCESSOR_CLASSES);
    private Map<Class<?>, Class<?>> processorBuilderClasses = new LinkedHashMap(EngineConstants.BASE_PROCESSOR_BUILDER_CLASSES);
    protected Object interpteterSynchro = new Object();
    protected ScriptClassInstanceProvider scriptClassInstancePovider;

    protected BaseScriptKnowledgeBaseInterpreter(KnowledgeBaseEngineOperations engineOperations, KnowledgeBaseType type) {
        super(engineOperations, type);
        this.prepareInterpreter();
        this.scriptClassInstancePovider = this.createScriptClassInstancePovider();
    }

    protected abstract void prepareInterpreter();

    protected abstract <T> ScriptClassInstanceProvider<T> createScriptClassInstancePovider();

    @Override
    protected <T> T doCreateInstance(String className, Class<T> javaClass) {
        return this.scriptClassInstancePovider.newInstance(className, javaClass);
    }

    protected final void invalidateCache() {
        this.scriptClassInstancePovider.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(List<KnowledgeBaseScript> scripts) {
        Object object = this.interpteterSynchro;
        synchronized (object) {
            scripts.forEach(script -> this.loadKnowledgeBaseScript((KnowledgeBaseScript)script));
        }
    }

    public final void load(String filename) {
        this.load(filename, Charset.defaultCharset());
    }

    public final void load(String filename, String charset) {
        this.load(filename, Charset.forName(charset));
    }

    public final void load(String filename, Charset charset) {
        this.load(filename, charset, true);
    }

    public final void load(String filename, Charset charset, boolean required) {
        this.load(new FileKnowledgeBaseScript(filename, charset, required));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(KnowledgeBaseScript script) {
        Object object = this.interpteterSynchro;
        synchronized (object) {
            this.invalidateCache();
            SpongeEngine engine = this.getEngineOperations().getEngine();
            List readers = null;
            try {
                readers = engine.getKnowledgeBaseManager().getKnowledgeBaseScriptProvider(script).getReaders();
                readers.forEach(reader -> {
                    if (script != null && script.getKnowledgeBase() != null) {
                        logger.info("Loading '{}' knowledge base file: {}.", (Object)script.getKnowledgeBase().getName(), (Object)reader.getFilename());
                    } else {
                        logger.info("Loading knowledge base file: {}.", (Object)reader.getFilename());
                    }
                    try {
                        this.doLoad(reader.getReader(), reader.getFilename());
                    }
                    catch (Throwable e) {
                        throw SpongeUtils.wrapException(reader.getFilename(), this, e);
                    }
                });
            }
            catch (Throwable e) {
                throw SpongeUtils.wrapException(script.getName(), this, e);
            }
            finally {
                if (readers != null) {
                    readers.forEach(reader -> SpongeUtils.closeQuietly(reader.getReader()));
                }
            }
        }
    }

    protected void doLoad(Reader reader, String name) {
        this.eval(reader, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload(List<KnowledgeBaseScript> scripts) {
        Object object = this.interpteterSynchro;
        synchronized (object) {
            this.doReload(scripts);
        }
    }

    protected void doReload(List<KnowledgeBaseScript> scripts) {
        this.load(scripts);
    }

    private void loadKnowledgeBaseScript(KnowledgeBaseScript script) {
        this.load(script);
    }

    public void onInit() {
        this.invokeOptionalFunction("onInit", null);
    }

    public void onBeforeLoad() {
        this.invokeOptionalFunction("onBeforeLoad", null);
    }

    public void onLoad() {
        this.invokeOptionalFunction("onLoad", null);
    }

    public void onAfterLoad() {
        this.invokeOptionalFunction("onAfterLoad", null);
    }

    public void onStartup() {
        this.invokeOptionalFunction("onStartup", null);
    }

    public boolean onRun() {
        Object result = this.invokeOptionalFunction("onRun", null);
        if (result != null) {
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            throw new SpongeException("The knowledge base onRun callback function should return a boolean value, not: " + result.getClass());
        }
        return EngineConstants.DEFAULT_ON_RUN_FUNCTION_RESULT;
    }

    public void onShutdown() {
        this.invokeOptionalFunction("onShutdown", null);
    }

    public void onBeforeReload() {
        this.invokeOptionalFunction("onBeforeReload", null);
    }

    public void onAfterReload() {
        this.invokeOptionalFunction("onAfterReload", null);
    }

    public <T> T eval(String expression, Class<T> cls) {
        return (T)this.eval(expression);
    }

    public abstract <T> T eval(Reader var1, String var2);

    protected abstract ScriptKnowledgeBaseInterpreter createInterpreterInstance(SpongeEngine var1, KnowledgeBase var2);

    protected List<Class<?>> getStandardImportClasses() {
        ArrayList classes = new ArrayList();
        classes.addAll(Arrays.asList(EventMode.class, EventClonePolicy.class, SpongeUtils.class, SpongeException.class, ProcessorType.class, Event.class, Configuration.class, EventSetProcessorState.class, EventName.class, ProvidedMeta.class, ProvidedMode.class, ProvidedValue.class, AnnotatedValue.class, DynamicValue.class, SubmittableMeta.class, OutputStreamValue.class, CategoryMeta.class, DateTimeKind.class, ValueSetMeta.class, Duration.class, Instant.class, ChronoUnit.class, TimeUnit.class, Features.class, RuleEventSpec.class, ProvideArgsParameters.class, GeoPosition.class, GeoTileLayer.class, GeoMarkerLayer.class, GeoMap.class, IconInfo.class));
        classes.addAll(SpongeUtils.getSupportedTypes());
        return classes;
    }

    protected boolean isProcessorAbstract(String className) {
        return className.startsWith("Abstract");
    }

    public ProcessorInstanceHolder createProcessorInstanceByProcessorClass(KnowledgeBase knowledgeBase, Object processorClass, Class<?> javaClass) {
        String name = knowledgeBase.getInterpreter().getScriptKnowledgeBaseProcessorClassName(processorClass);
        return name != null ? new DefaultProcessorInstanceHolder((Processor<?>)this.createProcessorInstance(name, javaClass), name, false) : null;
    }

    protected Map<Class<?>, Class<?>> getProcessorClasses() {
        return this.processorClasses;
    }

    protected void overwriteProcessorClass(Class<?> interfaceCls, Class<?> processorCls) {
        this.processorClasses.put(interfaceCls, processorCls);
    }

    protected void overwriteProcessorBuilderClass(Class<?> interfaceCls, Class<?> processorBuilderCls) {
        this.processorBuilderClasses.put(interfaceCls, processorBuilderCls);
    }

    protected Map<Class<?>, Class<?>> getSimplifiedImportClasses() {
        LinkedHashMap classes = new LinkedHashMap();
        classes.putAll(this.processorClasses);
        classes.putAll(this.processorBuilderClasses);
        return classes;
    }
}

