/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.AbstractRuleAdapter;
import org.openksavi.sponge.core.rule.BaseRuleDefinition;
import org.openksavi.sponge.core.rule.BaseRuleMeta;
import org.openksavi.sponge.core.rule.OrderedRuleAdapterRuntime;
import org.openksavi.sponge.core.rule.RuleAdapterRuntime;
import org.openksavi.sponge.core.rule.UnorderedRuleAdapterRuntime;
import org.openksavi.sponge.core.util.Tree;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.Rule;
import org.openksavi.sponge.rule.RuleEventSpec;

public class BaseRuleAdapter
extends AbstractRuleAdapter<Rule> {
    private RuleAdapterRuntime runtime;

    public BaseRuleAdapter(BaseRuleDefinition definition) {
        super(definition);
    }

    public ProcessorType getType() {
        return ProcessorType.RULE;
    }

    @Override
    public BaseRuleMeta getMeta() {
        return super.getMeta();
    }

    @Override
    public void onEvent(Event event) {
        this.lock.lock();
        try {
            this.runtime.onEvent(event);
        }
        finally {
            this.lock.unlock();
        }
    }

    public SpongeException createValidationException(String text) {
        return new SpongeException("Invalid rule " + this.getMeta().getName() + ". " + text);
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.runtime.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public RuleAdapterRuntime getRuntime() {
        if (this.runtime == null) {
            this.runtime = this.getMeta().isOrdered() ? new OrderedRuleAdapterRuntime(this) : new UnorderedRuleAdapterRuntime(this);
        }
        return this.runtime;
    }

    public boolean acceptAsFirst(Event event) {
        return this.getRuntime().acceptAsFirst(event);
    }

    @Override
    protected boolean runRule() {
        return this.getRuntime().runRule();
    }

    @Override
    public boolean isCandidateForFirstEvent(Event event) {
        return this.getRuntime().isCandidateForFirstEvent(event);
    }

    @Override
    public Event getFirstEvent() {
        return this.getRuntime().getFirstEvent();
    }

    public Event getEvent(String eventAlias) {
        return this.getRuntime().getEvent(eventAlias);
    }

    public final Map<String, Event> getEventAliasMap() {
        return this.getRuntime().getEventAliasMap();
    }

    public final List<Event> getEventSequence() {
        return this.getRuntime().getEventSequence();
    }

    public final Tree<RuleAdapterRuntime.NodeValue> getEventTree() {
        return this.getRuntime().getEventTree();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMeta().getEventSpecs() == null || this.getMeta().getEventSpecs().isEmpty()) {
            throw this.createValidationException("Event specifications are missing.");
        }
        if (this.getMeta().getEventNames().size() != this.getMeta().getEventSpecs().size()) {
            throw this.createValidationException("Each event should have a specification (explicitly or implicitly).");
        }
        if (this.getMeta().getEventSpecs().stream().map(RuleEventSpec::getAlias).distinct().count() < (long)this.getMeta().getEventSpecs().size()) {
            throw this.createValidationException("Event aliases together with names must be unique.");
        }
        Set eventAliasesSet = this.getMeta().getEventSpecs().stream().map(RuleEventSpec::getAlias).collect(Collectors.toSet());
        for (String alias : this.getMeta().getEventConditions().keySet()) {
            if (eventAliasesSet.contains(alias)) continue;
            throw this.createValidationException("Condition event alias '" + alias + "' does not exist");
        }
        this.getRuntime().validate();
    }
}

