/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openksavi.sponge.core.shaded.com.google.common.collect.Lists;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.Rule;

public class CompositeEventCondition
implements EventCondition {
    private List<EventCondition> conditions;

    public CompositeEventCondition(EventCondition ... conditions) {
        this.conditions = Lists.newArrayList(conditions);
    }

    public CompositeEventCondition(List<EventCondition> conditions) {
        this.conditions = Lists.newArrayList(conditions);
    }

    public boolean condition(Rule rule, Event event) {
        for (EventCondition condition : this.conditions) {
            if (condition.condition(rule, event)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> CompositeEventCondition create(Function<? super T, ? extends EventCondition> mapper, T ... conditionTemplates) {
        return CompositeEventCondition.create(mapper, Arrays.asList(conditionTemplates));
    }

    public static <T> CompositeEventCondition create(Function<? super T, ? extends EventCondition> mapper, List<T> conditionTemplates) {
        return new CompositeEventCondition(conditionTemplates.stream().map(mapper).collect(Collectors.toList()));
    }
}

