/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.core.shaded.com.google.common.cache.CacheBuilder;
import org.openksavi.sponge.core.shaded.com.google.common.cache.CacheLoader;
import org.openksavi.sponge.core.shaded.com.google.common.cache.LoadingCache;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.util.PatternMatcher;

public class RegexPatternMatcher
implements PatternMatcher {
    private LoadingCache<String, Pattern> compiledPatterns = CacheBuilder.newBuilder().build(new CacheLoader<String, Pattern>(){

        @Override
        public Pattern load(String pattern) throws Exception {
            return RegexPatternMatcher.this.compilePattern(pattern);
        }
    });

    protected Pattern compilePattern(String pattern) {
        return Pattern.compile(pattern);
    }

    public void validatePattern(String pattern) {
        Validate.notNull((Object)this.compilePattern(pattern));
    }

    public Pattern getPattern(String pattern) {
        try {
            return this.compiledPatterns.get(pattern);
        }
        catch (ExecutionException e) {
            throw SpongeUtils.wrapException(e.getCause() != null ? e.getCause() : e);
        }
    }

    public boolean matches(String pattern, String text) {
        return this.getPattern(pattern).matcher(text).matches();
    }

    public boolean matchesAny(List<String> patterns, String text) {
        for (String pattern : patterns) {
            if (!this.matches(pattern, text)) continue;
            return true;
        }
        return false;
    }
}

