/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core;

import java.util.List;
import org.openksavi.sponge.EventProcessor;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.BaseEventProcessorDefinition;
import org.openksavi.sponge.core.BaseEventProcessorMeta;
import org.openksavi.sponge.core.BaseProcessorAdapter;
import org.openksavi.sponge.core.BaseProcessorDefinition;

public abstract class BaseEventProcessorAdapter<T extends EventProcessor<?>>
extends BaseProcessorAdapter<T>
implements EventProcessorAdapter<T> {
    protected BaseEventProcessorAdapter(BaseProcessorDefinition definition) {
        super(definition);
    }

    @Override
    public BaseEventProcessorDefinition getDefinition() {
        return (BaseEventProcessorDefinition)super.getDefinition();
    }

    @Override
    public BaseEventProcessorMeta getMeta() {
        return (BaseEventProcessorMeta)super.getMeta();
    }

    @Override
    public void validate() {
        super.validate();
        List<String> eventNames = this.getMeta().getEventNames();
        if (eventNames == null || eventNames.isEmpty()) {
            throw new SpongeException("Invalid " + this.getType().getName() + " " + this.getMeta().getName() + ". At least one event must be specified.");
        }
        for (String eventName : eventNames) {
            this.getKnowledgeBase().getEngineOperations().getEngine().getPatternMatcher().validatePattern(eventName);
        }
    }
}

