/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ExceptionContext;
import org.openksavi.sponge.engine.ExceptionHandler;

public class SystemErrExceptionHandler
implements ExceptionHandler {
    private boolean includeStackTrace;
    private boolean simplified;

    public SystemErrExceptionHandler(boolean includeStackTrace, boolean simplified) {
        this.includeStackTrace = includeStackTrace;
        this.simplified = simplified;
    }

    public SystemErrExceptionHandler() {
        this(true, false);
    }

    public boolean isIncludeStackTrace() {
        return this.includeStackTrace;
    }

    public void setIncludeStackTrace(boolean includeStackTrace) {
        this.includeStackTrace = includeStackTrace;
    }

    public boolean isSimplified() {
        return this.simplified;
    }

    public void setSimplified(boolean simplified) {
        this.simplified = simplified;
    }

    public void handleException(Throwable exception, ExceptionContext context) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            message = exception.toString();
        }
        System.err.println(this.simplified ? "ERROR: " + message : SpongeUtils.createErrorMessage(exception, context, this.includeStackTrace));
    }
}

