/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.event;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EventId
implements Serializable,
Comparable<EventId> {
    private static final long serialVersionUID = -2182861627248524552L;
    private static final String SEPARATOR = "-";
    private long baseTimestamp;
    private long id;

    public EventId(long baseTimestamp, long id) {
        this.baseTimestamp = baseTimestamp;
        this.id = id;
    }

    public long getBaseTimestamp() {
        return this.baseTimestamp;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return this.baseTimestamp + SEPARATOR + this.id;
    }

    public static EventId fromString(String s) {
        String[] elements = StringUtils.split((String)s, (String)SEPARATOR);
        return new EventId(Long.parseLong(elements[0]), Long.parseLong(elements[1]));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EventId eventId = (EventId)obj;
        return new EqualsBuilder().append(this.baseTimestamp, eventId.baseTimestamp).append(this.id, eventId.id).build();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.baseTimestamp).append(this.id).build();
    }

    @Override
    public int compareTo(EventId event) {
        return new CompareToBuilder().append(this.baseTimestamp, event.baseTimestamp).append(this.id, event.id).toComparison();
    }

    public static int compare(String id1, String id2) {
        return EventId.fromString(id1).compareTo(EventId.fromString(id2));
    }
}

