/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.MethodNameEventCondition;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.Rule;

public class ReflectionEventCondition
extends MethodNameEventCondition {
    private Method method;

    protected ReflectionEventCondition(Method method) {
        super(method.getName());
        this.method = method;
    }

    public synchronized boolean condition(Rule rule, Event event) {
        try {
            Object result = this.method.invoke((Object)rule, event);
            if (!(result instanceof Boolean)) {
                throw new IllegalArgumentException("Condition method must return a boolean value");
            }
            return (Boolean)result;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                throw new SpongeException(e.getCause());
            }
            throw new SpongeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SpongeException((Throwable)e);
        }
    }

    public static ReflectionEventCondition create(Rule rule, String methodName) {
        return new ReflectionEventCondition(ReflectionEventCondition.resolveMethod(rule, methodName));
    }

    public static Method resolveMethod(Rule rule, String methodName) {
        Method method = MethodUtils.getMatchingMethod(rule.getClass(), (String)methodName, (Class[])new Class[]{Event.class});
        if (method == null) {
            throw new IllegalArgumentException("Event condition method " + methodName + " not found in rule " + rule.getMeta().getName());
        }
        return method;
    }
}

