/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.EventProcessorAdapter;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorAdapter;
import org.openksavi.sponge.ProcessorAdapterFactory;
import org.openksavi.sponge.ProcessorBuilder;
import org.openksavi.sponge.ProcessorDefinition;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.core.BaseProcessorAdapter;
import org.openksavi.sponge.core.BaseProcessorDefinition;
import org.openksavi.sponge.core.correlator.BaseCorrelatorAdapter;
import org.openksavi.sponge.core.correlator.BaseCorrelatorAdapterGroup;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.engine.BuilderProcessorProvider;
import org.openksavi.sponge.core.engine.ClassProcessorProvider;
import org.openksavi.sponge.core.kb.BaseKnowledgeBase;
import org.openksavi.sponge.core.rule.BaseRuleAdapter;
import org.openksavi.sponge.core.rule.BaseRuleAdapterGroup;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.correlator.CorrelatorAdapter;
import org.openksavi.sponge.correlator.CorrelatorAdapterGroup;
import org.openksavi.sponge.engine.InitialProcessorInstance;
import org.openksavi.sponge.engine.ProcessorManager;
import org.openksavi.sponge.engine.ProcessorProvider;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.engine.processing.EventSetProcessorMainProcessingUnitHandler;
import org.openksavi.sponge.filter.FilterAdapter;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.rule.RuleAdapter;
import org.openksavi.sponge.rule.RuleAdapterGroup;
import org.openksavi.sponge.trigger.TriggerAdapter;

public class DefaultProcessorManager
extends BaseEngineModule
implements ProcessorManager {
    protected Map<ProcessorType, RegistrationHandler> registrationHandlers = SpongeUtils.immutableMapOf(ProcessorType.ACTION, new RegistrationHandler(adapter -> this.getEngine().getActionManager().addAction((ActionAdapter)adapter), name -> this.getEngine().getActionManager().removeAction(name), name -> this.getEngine().getActionManager().hasAction(name)), ProcessorType.FILTER, new RegistrationHandler(adapter -> this.getEngine().getFilterProcessingUnit().addProcessor((EventProcessorAdapter)((FilterAdapter)adapter)), name -> this.getEngine().getFilterProcessingUnit().removeProcessor(name), name -> this.getEngine().getFilterProcessingUnit().hasProcessor(name)), ProcessorType.TRIGGER, new RegistrationHandler(adapter -> this.getEngine().getMainProcessingUnit().addProcessor((EventProcessorAdapter)((TriggerAdapter)adapter)), name -> this.getEngine().getMainProcessingUnit().removeProcessor(name), name -> this.getEngine().getMainProcessingUnit().hasProcessor(name, ProcessorType.TRIGGER)), ProcessorType.RULE, new RegistrationHandler(adapter -> this.getEngine().getMainProcessingUnit().addProcessor((EventProcessorAdapter)new BaseRuleAdapterGroup((BaseRuleAdapter)adapter, (EventSetProcessorMainProcessingUnitHandler<RuleAdapterGroup, RuleAdapter>)((EventSetProcessorMainProcessingUnitHandler)this.getEngine().getMainProcessingUnit().getHandler(ProcessorType.RULE_GROUP)))), name -> this.getEngine().getMainProcessingUnit().removeProcessor(name), name -> this.getEngine().getMainProcessingUnit().hasProcessor(name, ProcessorType.RULE_GROUP)), ProcessorType.CORRELATOR, new RegistrationHandler(adapter -> this.getEngine().getMainProcessingUnit().addProcessor((EventProcessorAdapter)new BaseCorrelatorAdapterGroup((BaseCorrelatorAdapter)adapter, (EventSetProcessorMainProcessingUnitHandler<CorrelatorAdapterGroup, CorrelatorAdapter>)((EventSetProcessorMainProcessingUnitHandler)this.getEngine().getMainProcessingUnit().getHandler(ProcessorType.CORRELATOR_GROUP)))), name -> this.getEngine().getMainProcessingUnit().removeProcessor(name), name -> this.getEngine().getMainProcessingUnit().hasProcessor(name, ProcessorType.CORRELATOR_GROUP)));
    private Lock lock = new ReentrantLock(true);

    public DefaultProcessorManager(SpongeEngine engine) {
        super("ProcessorManager", engine);
    }

    @Override
    public BaseSpongeEngine getEngine() {
        return (BaseSpongeEngine)super.getEngine();
    }

    public void enable(KnowledgeBase knowledgeBase, Object processorClass) {
        Validate.notNull((Object)processorClass, (String)"Processor class cannot be null", (Object[])new Object[0]);
        this.doEnable(knowledgeBase, new ClassProcessorProvider(processorClass), null);
    }

    public <T extends Processor<?>> void enable(KnowledgeBase knowledgeBase, ProcessorBuilder<T> processorBuilder) {
        Validate.notNull(processorBuilder, (String)"Processor builder cannot be null", (Object[])new Object[0]);
        this.doEnable(knowledgeBase, new BuilderProcessorProvider<T>(processorBuilder), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doEnable(KnowledgeBase knowledgeBase, ProcessorProvider processorProvider, ProcessorType requiredType) {
        this.lock.lock();
        try {
            SpongeUtils.doInWrappedException(knowledgeBase, () -> {
                InitialProcessorInstance initialInstance = processorProvider.createInitialProcessorInstance(knowledgeBase, Processor.class);
                BaseProcessorAdapter adapter = this.createAdapter(initialInstance.getProcessor(), requiredType, processorProvider);
                this.bindAdapter(knowledgeBase, initialInstance.getName(), initialInstance.getProcessor(), adapter);
                this.initializeProcessor(initialInstance.getProcessor(), adapter);
                this.getRegistrationHandler(adapter.getType()).register(adapter);
            }, "enable");
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disable(KnowledgeBase knowledgeBase, String processorName) {
        this.lock.lock();
        try {
            this.registrationHandlers.forEach((type, handler) -> {
                if (handler.exists(processorName)) {
                    handler.deregister(processorName);
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disable(KnowledgeBase knowledgeBase, Object processorClass) {
        this.doDisable(knowledgeBase, processorClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDisable(KnowledgeBase knowledgeBase, Object processorClass, ProcessorType requiredType) {
        this.lock.lock();
        try {
            ClassProcessorProvider processorProvider = new ClassProcessorProvider(processorClass);
            InitialProcessorInstance initialInstance = processorProvider.createInitialProcessorInstance(knowledgeBase, Processor.class);
            BaseProcessorAdapter adapter = this.createAdapter(initialInstance.getProcessor(), requiredType, processorProvider);
            this.bindAdapter(knowledgeBase, initialInstance.getName(), initialInstance.getProcessor(), adapter);
            this.getRegistrationHandler(adapter.getType()).deregister(adapter.getMeta().getName());
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T extends Processor> T createProcessorInstance(ProcessorDefinition definition, Class<T> cls) {
        Validate.isInstanceOf(BaseProcessorDefinition.class, (Object)definition, (String)"Processor definition must be or extend %s", (Object[])new Object[]{BaseProcessorDefinition.class});
        BaseProcessorDefinition baseDefinition = (BaseProcessorDefinition)definition;
        return (T)baseDefinition.getProcessorProvider().createAdditionalProcessorInstance((ProcessorDefinition)baseDefinition, cls);
    }

    protected BaseProcessorAdapter createAdapter(Processor processor, ProcessorType requiredType, ProcessorProvider processorProvider) {
        Validate.isInstanceOf(ProcessorAdapterFactory.class, (Object)processor, (String)"Processor must implement %s", (Object[])new Object[]{ProcessorAdapterFactory.class});
        ProcessorAdapter adapter = ((ProcessorAdapterFactory)processor).createAdapter();
        Validate.isInstanceOf(BaseProcessorAdapter.class, (Object)adapter, (String)"Processor adapter must extend %s", (Object[])new Object[]{BaseProcessorAdapter.class});
        BaseProcessorAdapter baseAdapter = (BaseProcessorAdapter)adapter;
        baseAdapter.getDefinition().setProcessorProvider(processorProvider);
        if (requiredType != null) {
            Validate.isTrue((adapter.getType() == requiredType ? 1 : 0) != 0, (String)"%s is %s but should be %s", (Object[])new Object[]{adapter.getMeta().getName(), adapter.getType().getLabel(), requiredType.getLabel()});
        }
        return baseAdapter;
    }

    protected void bindAdapter(KnowledgeBase knowledgeBase, String name, Processor processor, BaseProcessorAdapter adapter) {
        adapter.setKnowledgeBase((BaseKnowledgeBase)knowledgeBase);
        adapter.setProcessor(processor);
        processor.getMeta().setName(name);
    }

    protected void initializeProcessor(Processor processor, BaseProcessorAdapter adapter) {
        SpongeUtils.doInWrappedException(adapter.getKnowledgeBase(), () -> processor.onConfigure(), SpongeUtils.getProcessorQualifiedName(adapter) + ".onConfigure");
        Optional<Map.Entry<ProcessorType, RegistrationHandler>> alreadyRegistered = this.findAlreadyRegisteredByDifferentType(adapter);
        if (alreadyRegistered.isPresent()) {
            Validate.isTrue((boolean)false, (String)"%s named '%s' has already been registered as %s type", (Object[])new Object[]{adapter.getType().getLabel(), adapter.getMeta().getName(), alreadyRegistered.get().getKey().getLabel()});
        }
        SpongeUtils.doInWrappedException(adapter.getKnowledgeBase(), () -> processor.getAdapter().validate(), SpongeUtils.getProcessorQualifiedName(adapter).toString());
        if (processor.getAdapter().getDefinition().isSingleton()) {
            SpongeUtils.doInWrappedException(adapter.getKnowledgeBase(), () -> processor.onInit(), SpongeUtils.getProcessorQualifiedName(adapter) + ".onInit");
        }
    }

    protected Optional<Map.Entry<ProcessorType, RegistrationHandler>> findAlreadyRegisteredByDifferentType(ProcessorAdapter adapter) {
        return this.registrationHandlers.entrySet().stream().filter(entry -> !((ProcessorType)entry.getKey()).equals((Object)adapter.getType()) && ((RegistrationHandler)entry.getValue()).exists(adapter.getMeta().getName())).findFirst();
    }

    protected RegistrationHandler getRegistrationHandler(ProcessorType type) {
        return (RegistrationHandler)Validate.notNull((Object)this.registrationHandlers.get(type), (String)"Unsupported processor type %s", (Object[])new Object[]{type});
    }

    public void enableAction(KnowledgeBase knowledgeBase, Object actionClass) {
        this.doEnable(knowledgeBase, new ClassProcessorProvider(actionClass), ProcessorType.ACTION);
    }

    public void enableFilter(KnowledgeBase knowledgeBase, Object filterClass) {
        this.doEnable(knowledgeBase, new ClassProcessorProvider(filterClass), ProcessorType.FILTER);
    }

    public void enableTrigger(KnowledgeBase knowledgeBase, Object triggerClass) {
        this.doEnable(knowledgeBase, new ClassProcessorProvider(triggerClass), ProcessorType.TRIGGER);
    }

    public void enableRule(KnowledgeBase knowledgeBase, Object ruleClass) {
        this.doEnable(knowledgeBase, new ClassProcessorProvider(ruleClass), ProcessorType.RULE);
    }

    public void enableCorrelator(KnowledgeBase knowledgeBase, Object correlatorClass) {
        this.doEnable(knowledgeBase, new ClassProcessorProvider(correlatorClass), ProcessorType.CORRELATOR);
    }

    public void disableAction(KnowledgeBase knowledgeBase, Object actionClass) {
        this.doDisable(knowledgeBase, actionClass, ProcessorType.ACTION);
    }

    public void disableFilter(KnowledgeBase knowledgeBase, Object filterClass) {
        this.doDisable(knowledgeBase, filterClass, ProcessorType.FILTER);
    }

    public void disableTrigger(KnowledgeBase knowledgeBase, Object triggerClass) {
        this.doDisable(knowledgeBase, triggerClass, ProcessorType.TRIGGER);
    }

    public void disableRule(KnowledgeBase knowledgeBase, Object ruleClass) {
        this.doDisable(knowledgeBase, ruleClass, ProcessorType.RULE);
    }

    public void disableCorrelator(KnowledgeBase knowledgeBase, Object correlatorClass) {
        this.doDisable(knowledgeBase, correlatorClass, ProcessorType.CORRELATOR);
    }

    protected String resolveProcessorName(KnowledgeBase knowledgeBase, Object processorClass, Class javaClass) {
        Validate.notNull((Object)processorClass, (String)"Processor class cannot be null", (Object[])new Object[0]);
        String name = knowledgeBase.getInterpreter().getScriptKnowledgeBaseProcessorClassName(processorClass);
        if (name != null) {
            return name;
        }
        if (processorClass instanceof Class) {
            Class destJavaClass = (Class)processorClass;
            if (!javaClass.isAssignableFrom(destJavaClass)) {
                throw new SpongeException("Unsupported processor specification: " + destJavaClass.getName() + " can't be used as " + javaClass.getName());
            }
            return destJavaClass.getName();
        }
        throw new SpongeException("Unsupported processor class: " + processorClass);
    }

    public List<ProcessorAdapter> getAllProcessorAdapters() {
        ArrayList<ProcessorAdapter> processors = new ArrayList<ProcessorAdapter>();
        processors.addAll(this.getEngine().getActionManager().getRegisteredActionAdapterMap().values());
        processors.addAll(this.getEngine().getFilterProcessingUnit().getRegisteredProcessorAdapterMap().values());
        processors.addAll(this.getEngine().getMainProcessingUnit().getRegisteredProcessorAdapterMap().values());
        return processors;
    }

    protected static class RegistrationHandler {
        private Consumer<ProcessorAdapter> registration;
        private Consumer<String> deregistration;
        private Predicate<String> existence;

        public RegistrationHandler(Consumer<ProcessorAdapter> registration, Consumer<String> deregistration, Predicate<String> existence) {
            this.registration = registration;
            this.deregistration = deregistration;
            this.existence = existence;
        }

        public void register(ProcessorAdapter adapter) {
            this.registration.accept(adapter);
        }

        public void deregister(String name) {
            this.deregistration.accept(name);
        }

        public boolean exists(String name) {
            return this.existence.test(name);
        }
    }
}

