/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openksavi.sponge.ProcessorOnInitCallback;
import org.openksavi.sponge.core.BaseEventSetProcessorBuilder;
import org.openksavi.sponge.core.rule.BaseRuleMeta;
import org.openksavi.sponge.core.rule.DefaultBuilderRule;
import org.openksavi.sponge.rule.EventCondition;
import org.openksavi.sponge.rule.Rule;
import org.openksavi.sponge.rule.RuleBuilder;
import org.openksavi.sponge.rule.RuleEventSpec;
import org.openksavi.sponge.rule.RuleOnRunCallback;

public class BaseRuleBuilder
extends BaseEventSetProcessorBuilder<Rule>
implements RuleBuilder {
    private List<Object> genericEventSpecs = new ArrayList<Object>();
    private RuleOnRunCallback onRunCallback;

    public BaseRuleBuilder(String name) {
        super(new BaseRuleMeta(), name);
    }

    @Override
    public BaseRuleMeta getMeta() {
        return (BaseRuleMeta)super.getMeta();
    }

    @Override
    public BaseRuleBuilder withName(String name) {
        return (BaseRuleBuilder)super.withName(name);
    }

    @Override
    public BaseRuleBuilder withLabel(String label) {
        return (BaseRuleBuilder)super.withLabel(label);
    }

    @Override
    public BaseRuleBuilder withDescription(String description) {
        return (BaseRuleBuilder)super.withDescription(description);
    }

    @Override
    public BaseRuleBuilder withVersion(Integer version) {
        return (BaseRuleBuilder)super.withVersion(version);
    }

    public BaseRuleBuilder withFeatures(Map<String, Object> features) {
        return (BaseRuleBuilder)super.withFeatures((Map)features);
    }

    @Override
    public BaseRuleBuilder withFeature(String name, Object value) {
        return (BaseRuleBuilder)super.withFeature(name, value);
    }

    @Override
    public BaseRuleBuilder withCategory(String category) {
        return (BaseRuleBuilder)super.withCategory(category);
    }

    public BaseRuleBuilder withEvents(List<String> eventStringSpecs) {
        this.genericEventSpecs.addAll(eventStringSpecs);
        return this;
    }

    @Override
    public BaseRuleBuilder withEvent(String eventStringSpec) {
        return this.withEvents((List)Arrays.asList(eventStringSpec));
    }

    public BaseRuleBuilder withDuration(Duration duration) {
        return (BaseRuleBuilder)super.withDuration(duration);
    }

    public BaseRuleBuilder withSynchronous(Boolean synchronous) {
        return (BaseRuleBuilder)super.withSynchronous(synchronous);
    }

    public BaseRuleBuilder withEventSpecs(List<RuleEventSpec> eventSpecs) {
        this.genericEventSpecs.addAll(eventSpecs);
        return this;
    }

    public BaseRuleBuilder withEventSpec(RuleEventSpec eventSpec) {
        return this.withEventSpecs((List)Arrays.asList(eventSpec));
    }

    public BaseRuleBuilder withOrdered(boolean ordered) {
        this.getMeta().setOrdered(ordered);
        return this;
    }

    public BaseRuleBuilder withCondition(String eventAlias, EventCondition condition) {
        this.getMeta().addEventConditions(eventAlias, Arrays.asList(condition));
        return this;
    }

    public BaseRuleBuilder withAllCondition(EventCondition condition) {
        this.getMeta().addAllEventConditions(Arrays.asList(condition));
        return this;
    }

    public BaseRuleBuilder withOnInit(ProcessorOnInitCallback<Rule> onInitCallback) {
        return (BaseRuleBuilder)super.withOnInit((ProcessorOnInitCallback)onInitCallback);
    }

    public BaseRuleBuilder withOnRun(RuleOnRunCallback onRunCallback) {
        this.onRunCallback = onRunCallback;
        return this;
    }

    public List<Object> getGenericEventSpecs() {
        return this.genericEventSpecs;
    }

    public void setGenericEventSpecs(List<Object> genericEventSpecs) {
        this.genericEventSpecs = genericEventSpecs;
    }

    public RuleOnRunCallback getOnRunCallback() {
        return this.onRunCallback;
    }

    public void setOnRunCallback(RuleOnRunCallback onRunCallback) {
        this.onRunCallback = onRunCallback;
    }

    public Rule build() {
        return new DefaultBuilderRule(this);
    }
}

