/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.List;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorDefinition;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.InitialProcessorInstance;
import org.openksavi.sponge.engine.ProcessorInstanceHolder;
import org.openksavi.sponge.engine.ProcessorProvider;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseInterpreter;

public class ClassProcessorProvider<T extends Processor<?>>
implements ProcessorProvider<T> {
    private Object processorClass;
    private Class<?> processorJavaClass;
    private boolean javaDefined = false;

    public ClassProcessorProvider(Object processorClass) {
        this.processorClass = processorClass;
    }

    public InitialProcessorInstance<T> createInitialProcessorInstance(KnowledgeBase knowledgeBase, Class<T> cls) {
        ProcessorInstanceHolder holder = knowledgeBase.getInterpreter().createProcessorInstanceByProcessorClass(knowledgeBase, this.processorClass, cls);
        if (holder == null) {
            holder = knowledgeBase.getEngineOperations().getEngine().getKnowledgeBaseManager().getDefaultKnowledgeBase().getInterpreter().createProcessorInstanceByProcessorClass(knowledgeBase, this.processorClass, cls);
        }
        if (holder == null) {
            throw new SpongeException("Unsupported processor class: " + this.processorClass);
        }
        this.javaDefined = holder.isJavaDefined();
        this.processorJavaClass = holder.getProcessor().getClass();
        return new InitialProcessorInstance(holder.getProcessor(), holder.getName());
    }

    public T createAdditionalProcessorInstance(ProcessorDefinition definition, Class<T> cls) {
        if (this.javaDefined) {
            try {
                if (this.processorJavaClass == null) {
                    throw new SpongeException("No corresponding Java class for processor: " + definition.getMeta().getName());
                }
                return (T)((Processor)this.processorJavaClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw SpongeUtils.wrapException(definition.getMeta().getName(), (Throwable)e);
            }
        }
        return (T)definition.getKnowledgeBase().getInterpreter().createProcessorInstance(definition.getMeta().getName(), cls);
    }

    public Object invokeActionOnCall(Action action, List<Object> args) {
        KnowledgeBaseInterpreter interpreter = this.javaDefined ? ((ActionAdapter)action.getAdapter()).getKnowledgeBase().getEngineOperations().getEngine().getKnowledgeBaseManager().getDefaultKnowledgeBase().getInterpreter() : ((ActionAdapter)action.getAdapter()).getKnowledgeBase().getInterpreter();
        return interpreter.invokeMethod((Object)action, "onCall", args != null ? args.toArray(new Object[args.size()]) : new Object[]{});
    }
}

