/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ExceptionContext;
import org.openksavi.sponge.engine.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingExceptionHandler
implements ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(LoggingExceptionHandler.class);
    private boolean includeStackTrace;

    public LoggingExceptionHandler(boolean includeStackTrace) {
        this.includeStackTrace = includeStackTrace;
    }

    public LoggingExceptionHandler() {
        this(true);
    }

    public boolean isIncludeStackTrace() {
        return this.includeStackTrace;
    }

    public void setIncludeStackTrace(boolean includeStackTrace) {
        this.includeStackTrace = includeStackTrace;
    }

    public void handleException(Throwable exception, ExceptionContext context) {
        logger.error(SpongeUtils.createErrorMessage(exception, context, this.includeStackTrace));
    }
}

