/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.kb;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.kb.BaseKnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseScript;
import org.openksavi.sponge.kb.KnowledgeBaseType;
import org.openksavi.sponge.kb.ScriptKnowledgeBase;
import org.openksavi.sponge.kb.ScriptKnowledgeBaseInterpreter;

public class DefaultScriptKnowledgeBase
extends BaseKnowledgeBase
implements ScriptKnowledgeBase {
    private boolean clearOnReload = false;
    private List<KnowledgeBaseScript> scripts = Collections.synchronizedList(new ArrayList());

    public DefaultScriptKnowledgeBase(String name, KnowledgeBaseType type) {
        this.setName(name);
        this.setType(type);
    }

    public DefaultScriptKnowledgeBase(String name) {
        this.setName(name);
    }

    public boolean isClearOnReload() {
        return this.clearOnReload;
    }

    public void setClearOnReload(boolean clearOnReload) {
        this.clearOnReload = clearOnReload;
    }

    public List<KnowledgeBaseScript> getScripts() {
        return this.scripts;
    }

    public void addScript(KnowledgeBaseScript script) {
        if (script.getKnowledgeBase() != null && !Objects.equals(script.getKnowledgeBase(), this)) {
            throw new SpongeException("A different knowledge base has already been assigned to this script instance");
        }
        script.setKnowledgeBase((ScriptKnowledgeBase)this);
        this.scripts.add(script);
    }

    public ScriptKnowledgeBaseInterpreter getInterpreter() {
        return (ScriptKnowledgeBaseInterpreter)super.getInterpreter();
    }

    public final void onInit() {
        this.getInterpreter().onInit();
    }

    public final void onBeforeLoad() {
        this.getInterpreter().onBeforeLoad();
    }

    public final void onLoad() {
        this.getInterpreter().onLoad();
    }

    public final void onAfterLoad() {
        this.getInterpreter().onAfterLoad();
    }

    public final void onClear() {
        if (this.getInterpreter() != null) {
            this.getInterpreter().onClear();
        }
    }

    public final void onStartup() {
        this.getInterpreter().onStartup();
    }

    public final boolean onRun() {
        return this.getInterpreter().onRun();
    }

    public final void onShutdown() {
        if (this.getInterpreter() != null) {
            this.getInterpreter().onShutdown();
        }
    }

    public final void onBeforeReload() {
        this.getInterpreter().onBeforeReload();
    }

    public final void onAfterReload() {
        this.getInterpreter().onAfterReload();
    }

    public void load() {
        this.getInterpreter().load(this.scripts);
    }

    public void load(String filename) {
        this.getInterpreter().load(filename);
    }

    public void load(String filename, String charset) {
        this.getInterpreter().load(filename, charset);
    }

    public void load(String filename, Charset charset) {
        this.getInterpreter().load(filename, charset);
    }

    public void reload() {
        this.getInterpreter().reload(this.scripts);
    }

    public void scanToAutoEnable() {
        this.getInterpreter().scanToAutoEnable();
    }
}

