/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.BaseRule;
import org.openksavi.sponge.core.rule.BaseRuleBuilder;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.Rule;
import org.openksavi.sponge.rule.RuleEventSpec;

public class DefaultBuilderRule
extends BaseRule {
    private BaseRuleBuilder builder;

    public DefaultBuilderRule(BaseRuleBuilder builder) {
        this.builder = builder;
    }

    public void onConfigure() {
        this.getMeta().update(this.builder.getMeta());
        this.getMeta().setEventSpecs(this.builder.getGenericEventSpecs().stream().map(genericEventSpec -> {
            if (genericEventSpec instanceof String) {
                return SpongeUtils.convertRuleEventSpec(this.getKnowledgeBase(), (String)((Object)genericEventSpec));
            }
            if (genericEventSpec instanceof RuleEventSpec) {
                return (RuleEventSpec)genericEventSpec;
            }
            throw new SpongeException("Unsupported rule event spec: " + (genericEventSpec != null ? genericEventSpec.getClass() : genericEventSpec));
        }).collect(Collectors.toList()));
        Validate.notNull((Object)this.builder.getOnRunCallback(), (String)"A rule onRun callback must be set", (Object[])new Object[0]);
    }

    @Override
    public void onInit() {
        if (this.builder.getOnInitCallback() != null) {
            this.builder.getOnInitCallback().onInit((Processor)this);
        } else {
            super.onInit();
        }
    }

    public void onRun(Event event) {
        this.builder.getOnRunCallback().onRun((Rule)this, event);
    }
}

