/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.correlator;

import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.core.correlator.BaseCorrelator;
import org.openksavi.sponge.core.correlator.BaseCorrelatorBuilder;
import org.openksavi.sponge.correlator.Correlator;
import org.openksavi.sponge.event.Event;

public class DefaultBuilderCorrelator
extends BaseCorrelator {
    private BaseCorrelatorBuilder builder;

    public DefaultBuilderCorrelator(BaseCorrelatorBuilder builder) {
        this.builder = builder;
    }

    public void onConfigure() {
        this.getMeta().update(this.builder.getMeta());
        Validate.notNull((Object)this.builder.getOnEventCallback(), (String)"A correlator onEvent callback must be set", (Object[])new Object[0]);
    }

    @Override
    public void onInit() {
        if (this.builder.getOnInitCallback() != null) {
            this.builder.getOnInitCallback().onInit((Processor)this);
        } else {
            super.onInit();
        }
    }

    @Override
    public boolean onAcceptAsFirst(Event event) {
        return this.builder.getOnAcceptAsFirstCallback() != null ? this.builder.getOnAcceptAsFirstCallback().onAcceptAsFirst((Correlator)this, event) : super.onAcceptAsFirst(event);
    }

    public void onEvent(Event event) {
        this.builder.getOnEventCallback().onEvent((Correlator)this, event);
    }

    @Override
    public void onDuration() {
        if (this.builder.getOnDurationCallback() != null) {
            this.builder.getOnDurationCallback().onDuration((Correlator)this);
        } else {
            super.onDuration();
        }
    }
}

