/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.Processor;
import org.openksavi.sponge.ProcessorBuilder;
import org.openksavi.sponge.ProcessorDefinition;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.core.action.DefaultBuilderAction;
import org.openksavi.sponge.engine.InitialProcessorInstance;
import org.openksavi.sponge.engine.ProcessorProvider;
import org.openksavi.sponge.kb.KnowledgeBase;

public class BuilderProcessorProvider<T extends Processor<?>>
implements ProcessorProvider<T> {
    private ProcessorBuilder<T> builder;

    public BuilderProcessorProvider(ProcessorBuilder<T> builder) {
        this.builder = builder;
    }

    public ProcessorBuilder<T> getBuilder() {
        return this.builder;
    }

    public void setBuilder(ProcessorBuilder<T> builder) {
        this.builder = builder;
    }

    public InitialProcessorInstance<T> createInitialProcessorInstance(KnowledgeBase knowledgeBase, Class<T> cls) {
        return new InitialProcessorInstance(this.builder.build(), this.builder.getName());
    }

    public T createAdditionalProcessorInstance(ProcessorDefinition definition, Class<T> cls) {
        Processor processor = this.builder.build();
        Validate.isInstanceOf(cls, (Object)processor, (String)"The builder builds %s which is not an instance of expected %s", (Object[])new Object[]{processor.getClass(), cls});
        return (T)processor;
    }

    public Object invokeActionOnCall(Action action, List<Object> args) {
        Validate.isInstanceOf(DefaultBuilderAction.class, (Object)action);
        return ((DefaultBuilderAction)action).onCall(args != null ? args.toArray(new Object[args.size()]) : new Object[]{});
    }
}

