/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.ProcessorNotFoundException;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.action.InactiveActionException;
import org.openksavi.sponge.action.IsActionActiveContext;
import org.openksavi.sponge.core.BaseProcessorDefinition;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ActionManager;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.util.SpongeApiUtils;
import org.openksavi.sponge.util.ValueHolder;

public class DefaultActionManager
extends BaseEngineModule
implements ActionManager {
    private Map<String, ActionAdapter> registeredActions = Collections.synchronizedMap(new LinkedHashMap());

    public DefaultActionManager(SpongeEngine engine) {
        super("ActionManager", engine);
    }

    public void addAction(ActionAdapter actionAdapter) {
        Validate.notNull((Object)actionAdapter, (String)"addAction called with null actionAdapter.", (Object[])new Object[0]);
        this.registeredActions.put(actionAdapter.getMeta().getName(), actionAdapter);
    }

    public void removeAction(String actionName) {
        Validate.notNull((Object)actionName, (String)"removeAction called with null action name.", (Object[])new Object[0]);
        this.registeredActions.remove(actionName);
    }

    public Object callAction(String actionName, List<Object> args) {
        ActionAdapter action = this.registeredActions.get(actionName);
        if (action == null) {
            throw new ProcessorNotFoundException(ProcessorType.ACTION, actionName);
        }
        return this.callAction(action, args);
    }

    public Object callAction(ActionAdapter actionAdapter, List<Object> args) {
        if (!actionAdapter.isActive(new IsActionActiveContext(args))) {
            throw new InactiveActionException(actionAdapter.getMeta().getName());
        }
        this.validateActionCallArgs(actionAdapter, args);
        try {
            return ((BaseProcessorDefinition)actionAdapter.getDefinition()).getProcessorProvider().invokeActionOnCall((Action)actionAdapter.getProcessor(), args);
        }
        catch (Throwable e) {
            throw SpongeUtils.wrapException(actionAdapter.getProcessor(), e);
        }
    }

    public Object callAction(String actionName, Map<String, ?> args) {
        ActionAdapter action = this.registeredActions.get(actionName);
        if (action == null) {
            throw new ProcessorNotFoundException(ProcessorType.ACTION, actionName);
        }
        return this.callAction(action, args);
    }

    public Object callAction(ActionAdapter actionAdapter, Map<String, ?> args) {
        return this.callAction(actionAdapter, SpongeUtils.buildActionArgsList(actionAdapter, args));
    }

    protected void validateActionCallArgs(ActionAdapter actionAdapter, List<Object> args) {
        if (args == null) {
            return;
        }
        SpongeApiUtils.validateActionCallArgs((List)actionAdapter.getMeta().getArgs(), args);
    }

    public ValueHolder<Object> callActionIfExists(String actionName, List<Object> args) {
        ActionAdapter action = this.registeredActions.get(actionName);
        if (action == null) {
            return null;
        }
        return new ValueHolder(this.callAction(action, args));
    }

    public ValueHolder<Object> callActionIfExists(String actionName, Map<String, ?> args) {
        ActionAdapter action = this.registeredActions.get(actionName);
        if (action == null) {
            return null;
        }
        return new ValueHolder(this.callAction(action, args));
    }

    public Map<String, ActionAdapter> getRegisteredActionAdapterMap() {
        return this.registeredActions;
    }

    public boolean hasAction(String name) {
        return this.registeredActions.containsKey(name);
    }

    public ActionAdapter getActionAdapter(String actionName) {
        return this.registeredActions.get(actionName);
    }

    public List<ActionAdapter> getActionAdapters(String knowledgeBaseRegexp, String actionNameRegexp) {
        return this.registeredActions.values().stream().filter(adapter -> !(knowledgeBaseRegexp != null && !adapter.getKnowledgeBase().getName().matches(knowledgeBaseRegexp) || actionNameRegexp != null && !adapter.getMeta().getName().matches(actionNameRegexp))).collect(Collectors.toList());
    }
}

