/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine;

import java.util.function.Supplier;
import org.openksavi.sponge.core.engine.MapVariables;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.Session;
import org.openksavi.sponge.engine.Variables;

public class DefaultSession
implements Session {
    private static final long serialVersionUID = 3402263770070460564L;
    protected String uuid;
    protected Variables variables = new MapVariables();

    protected DefaultSession() {
    }

    public void setVariable(String name, Object value) {
        this.variables.set(name, value);
    }

    public <T> T getVariable(String name) {
        return (T)this.variables.get(name);
    }

    public <T> T getVariable(Class<T> cls, String name) {
        return (T)this.variables.get(cls, name);
    }

    public <T> T getVariable(String name, T defaultValue) {
        return (T)this.variables.get(name, defaultValue);
    }

    public <T> T getVariable(Class<T> cls, String name, T defaultValue) {
        return (T)this.variables.get(cls, name, defaultValue);
    }

    public boolean hasVariable(String name) {
        return this.variables.has(name);
    }

    public void removeVariable(String name) {
        this.variables.remove(name);
    }

    public <T> void setVariableIfNone(String name, Supplier<T> supplier) {
        this.variables.setIfNone(name, supplier);
    }

    public String getUuid() {
        return this.uuid;
    }

    public static Session createNewSession() {
        DefaultSession session = new DefaultSession();
        session.uuid = SpongeUtils.getRandomUuidString();
        return session;
    }

    public void updateVariable(String name) {
    }
}

