/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.event;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.event.AtomicLongEventIdGenerator;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.engine.event.EventScheduler;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventIdGenerator;

public abstract class BaseEventScheduler
extends BaseEngineModule
implements EventScheduler {
    protected AtomicLong currentEntryId = new AtomicLong(1L);
    protected EventQueue outQueue;
    protected EventIdGenerator eventIdGenerator = new AtomicLongEventIdGenerator();

    protected BaseEventScheduler(SpongeEngine engine, EventQueue outQueue) {
        super("EventScheduler", engine);
        this.outQueue = outQueue;
    }

    public void scheduleNow(Event event) {
        this.validateEvent(event);
        Validate.isTrue((event.getId() == null && event.getTime() == null ? 1 : 0) != 0, (String)"The event with id %s has already been sent", (Object[])new Object[]{event.getId()});
        event.setId(this.eventIdGenerator.getNext());
        event.setTime(Instant.now());
        this.outQueue.put(event);
    }

    protected String getNextEntryId() {
        return this.getName() + "-" + this.currentEntryId.getAndIncrement();
    }

    public EventIdGenerator getEventIdGenerator() {
        return this.eventIdGenerator;
    }

    public void setEventIdGenerator(EventIdGenerator eventIdGenerator) {
        this.eventIdGenerator = eventIdGenerator;
    }

    protected void validateEvent(Event event) {
        Validate.notNull((Object)event, (String)"Event must not be null", (Object[])new Object[0]);
        SpongeUtils.validateEventName(event.getName());
    }
}

