/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.engine.event;

import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.core.engine.event.BaseEventScheduler;
import org.openksavi.sponge.core.event.QuartzEventSchedulerEntry;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.engine.event.EventQueue;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.event.EventSchedulerEntry;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzEventScheduler
extends BaseEventScheduler {
    private static final Logger logger = LoggerFactory.getLogger(QuartzEventScheduler.class);
    public static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    protected static final String KEY_PARAMETERS = "parameters";
    private Scheduler scheduler;
    private Lock lock = new ReentrantLock(true);

    public QuartzEventScheduler(SpongeEngine engine, EventQueue outQueue) {
        super(engine, outQueue);
    }

    @Override
    public void doStartup() {
        try {
            Properties props = new Properties();
            String name = this.getName() + "-" + SpongeUtils.getRandomUuidString();
            props.put("org.quartz.scheduler.instanceName", name);
            props.put("org.quartz.scheduler.instanceId", name);
            props.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
            props.put(PROP_THREAD_COUNT, Integer.toString(1));
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            schedulerFactory.initialize(props);
            this.scheduler = schedulerFactory.getScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
        }
    }

    @Override
    public void doShutdown() {
        if (this.scheduler != null) {
            try {
                this.scheduler.clear();
                this.scheduler.shutdown(true);
            }
            catch (SchedulerException e) {
                throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventSchedulerEntry doSchedule(Event event, Trigger trigger, boolean single) {
        this.validateEvent(event);
        this.lock.lock();
        try {
            JobDataMap data = new JobDataMap();
            EventSchedulerJobParameters parameters = new EventSchedulerJobParameters(this, event, single);
            data.put(KEY_PARAMETERS, (Object)parameters);
            JobDetail job = JobBuilder.newJob(EventSchedulerJob.class).withIdentity(this.getNextEntryId(), this.getName()).setJobData(data).build();
            try {
                this.scheduler.scheduleJob(job, trigger);
            }
            catch (SchedulerException e) {
                throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
            }
            QuartzEventSchedulerEntry entry = new QuartzEventSchedulerEntry(job.getKey(), event);
            parameters.setEntry(entry);
            logger.debug("Scheduling event: {}", (Object)event);
            QuartzEventSchedulerEntry quartzEventSchedulerEntry = entry;
            return quartzEventSchedulerEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    public EventSchedulerEntry scheduleAfter(Event event, long delay) {
        return this.scheduleAfter(event, delay, 0L);
    }

    public EventSchedulerEntry scheduleAfter(Event event, long delay, long interval) {
        TriggerBuilder builder = TriggerBuilder.newTrigger();
        if (delay > 0L) {
            builder.startAt(Date.from(Instant.now().plusMillis(delay)));
        }
        if (interval > 0L) {
            builder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval).repeatForever().withMisfireHandlingInstructionFireNow());
        }
        return this.doSchedule(event, builder.build(), interval == 0L);
    }

    public EventSchedulerEntry scheduleAt(Event event, long at) {
        return this.scheduleAt(event, at, 0L);
    }

    public EventSchedulerEntry scheduleAt(Event event, long at, long interval) {
        TriggerBuilder builder = TriggerBuilder.newTrigger();
        if (at >= 0L) {
            builder.startAt(new Date(at));
        }
        if (interval > 0L) {
            builder.withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval).repeatForever());
        }
        return this.doSchedule(event, builder.build(), interval == 0L);
    }

    public EventSchedulerEntry scheduleAt(Event event, String crontabSpec) {
        return this.doSchedule(event, TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)((String)Validate.notNull((Object)crontabSpec, (String)"Crontab specification cannot be null", (Object[])new Object[0])))).build(), false);
    }

    public boolean remove(EventSchedulerEntry entry) {
        logger.debug("Descheduling entry with id: {}", entry.getId());
        try {
            return this.scheduler.deleteJob((JobKey)entry.getId());
        }
        catch (SchedulerException e) {
            throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
        }
    }

    public List<EventSchedulerEntry> getEntries() {
        try {
            return this.scheduler.getCurrentlyExecutingJobs().stream().map(context -> ((EventSchedulerJobParameters)context.getMergedJobDataMap().get((Object)KEY_PARAMETERS)).getEntry()).collect(Collectors.toList());
        }
        catch (SchedulerException e) {
            throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public static class EventSchedulerJobParameters {
        private QuartzEventScheduler scheduler;
        private Event event;
        private boolean single;
        private EventSchedulerEntry entry;

        public EventSchedulerJobParameters(QuartzEventScheduler scheduler, Event event, boolean single) {
            this.scheduler = scheduler;
            this.event = event;
            this.single = single;
        }

        public QuartzEventScheduler getScheduler() {
            return this.scheduler;
        }

        public void setScheduler(QuartzEventScheduler scheduler) {
            this.scheduler = scheduler;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }

        public boolean isSingle() {
            return this.single;
        }

        public void setSingle(boolean single) {
            this.single = single;
        }

        public EventSchedulerEntry getEntry() {
            return this.entry;
        }

        public void setEntry(EventSchedulerEntry entry) {
            this.entry = entry;
        }
    }

    public static class EventSchedulerJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                EventSchedulerJobParameters parameters = (EventSchedulerJobParameters)context.getJobDetail().getJobDataMap().get((Object)QuartzEventScheduler.KEY_PARAMETERS);
                parameters.getScheduler().scheduleNow(parameters.isSingle() ? parameters.getEvent() : parameters.getEvent().clone());
            }
            catch (Throwable e) {
                if (e instanceof JobExecutionException) {
                    throw e;
                }
                throw new JobExecutionException(e);
            }
        }
    }
}

