/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.plugin;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.core.engine.BaseEngineModule;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.kb.KnowledgeBase;
import org.openksavi.sponge.kb.KnowledgeBaseEngineOperations;
import org.openksavi.sponge.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePlugin
extends BaseEngineModule
implements Plugin {
    private Configuration configuration;
    private KnowledgeBase knowledgeBase;

    public void setConfiguration(Configuration configuration, boolean configure) {
        this.configuration = configuration;
        if (configure) {
            this.onConfigure(configuration);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public void setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
    }

    @Override
    public final void doStartup() {
        this.onStartup();
    }

    @Override
    public final void doShutdown() {
        this.onShutdown();
    }

    public void onStartup() {
    }

    public void onShutdown() {
    }

    public void onBeforeReload() {
    }

    public void onAfterReload() {
    }

    public void onInit() {
    }

    public void onConfigure(Configuration configuration) {
    }

    @Override
    public final void startup() {
        super.startup();
    }

    @Override
    public final void shutdown() {
        super.shutdown();
    }

    protected KnowledgeBaseEngineOperations getEngineOperations() {
        return this.knowledgeBase.getEngineOperations();
    }

    public KnowledgeBaseEngineOperations getSponge() {
        return this.getEngineOperations();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.getName()).append("class", (Object)this.getClass().getName()).toString();
    }

    public Logger getLogger() {
        return LoggerFactory.getLogger((String)(SpongeUtils.createPluginLoggerName() + "." + (this.getName() != null ? this.getName() : this.getClass().getName())));
    }
}

