/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.rule.AbstractRuleAdapterRuntime;
import org.openksavi.sponge.core.rule.BaseRuleAdapter;
import org.openksavi.sponge.core.rule.RuleAdapterRuntime;
import org.openksavi.sponge.core.util.TreeNode;
import org.openksavi.sponge.event.Event;
import org.openksavi.sponge.rule.EventMode;

public class UnorderedRuleAdapterRuntime
extends AbstractRuleAdapterRuntime {
    private List<String> noneModeEventAliases = this.createNoneModeEventAliases();

    public UnorderedRuleAdapterRuntime(BaseRuleAdapter adapter) {
        super(adapter);
    }

    private List<String> createNoneModeEventAliases() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.adapter.getEventCount(); ++i) {
            if (this.getMeta().getEventSpec(i).getMode() != EventMode.NONE) continue;
            result.add(this.getMeta().getEventSpec(i).getAlias());
        }
        return result;
    }

    @Override
    public boolean isCandidateForFirstEvent(Event event) {
        return true;
    }

    protected Set<Integer> getPreviousHappenedEventIndexes(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        HashSet<Integer> happenedEventIndexes = new HashSet<Integer>();
        for (TreeNode<RuleAdapterRuntime.NodeValue> n = node.getParent(); n != null; n = n.getParent()) {
            happenedEventIndexes.add(n.getValue().getIndex());
        }
        return happenedEventIndexes;
    }

    @Override
    protected int getExpectedEventIndex(TreeNode<RuleAdapterRuntime.NodeValue> node, Event event) {
        List<String> eventNames = this.getMeta().getEventNames();
        Set<Integer> happenedEventIndexes = this.getPreviousHappenedEventIndexes(node);
        for (int i = 0; i < eventNames.size(); ++i) {
            if (happenedEventIndexes.contains(i) || !this.adapter.getKnowledgeBase().getEngineOperations().getEngine().getPatternMatcher().matches(eventNames.get(i), event.getName())) continue;
            node.getValue().setIndex(i);
            return i;
        }
        return -1;
    }

    @Override
    protected boolean shouldAddToEventTreeForFlaModes(TreeNode<RuleAdapterRuntime.NodeValue> newNode, Event event) {
        int index = this.getExpectedEventIndex(newNode, event);
        return index >= 0 && this.checkConditions(newNode);
    }

    @Override
    protected boolean shouldAddToEventTreeForNMode(TreeNode<RuleAdapterRuntime.NodeValue> parentNode, Mutable<TreeNode<RuleAdapterRuntime.NodeValue>> newNodeHolder, Event event) {
        this.handleNoneEventHappenedButShouldNot(parentNode, (TreeNode)newNodeHolder.getValue(), event);
        return false;
    }

    @Override
    protected boolean shouldRunRule() {
        return true;
    }

    protected List<TreeNode<RuleAdapterRuntime.NodeValue>> resolveSubNodesToRun(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        ArrayList<TreeNode<RuleAdapterRuntime.NodeValue>> result = new ArrayList<TreeNode<RuleAdapterRuntime.NodeValue>>();
        LinkedHashMap<Integer, TreeNode> mapFirst = new LinkedHashMap<Integer, TreeNode>();
        LinkedHashMap<Integer, TreeNode> mapLast = new LinkedHashMap<Integer, TreeNode>();
        boolean endLoop = false;
        ListIterator<TreeNode<RuleAdapterRuntime.NodeValue>> treeNodeIterator = node.getChildren().listIterator();
        block6: while (!endLoop && treeNodeIterator.hasNext()) {
            TreeNode child = (TreeNode)treeNodeIterator.next();
            int index = this.getEventIndex(child);
            EventMode eventMode = this.getMeta().getEventSpec(index).getMode();
            switch (eventMode) {
                case FIRST: {
                    if (mapFirst.containsKey(index)) continue block6;
                    mapFirst.put(index, child);
                    result.add(child);
                    continue block6;
                }
                case LAST: {
                    TreeNode oldLast = (TreeNode)mapLast.get(index);
                    mapLast.put(index, child);
                    if (oldLast != null) {
                        result.remove(oldLast);
                    }
                    result.add(child);
                    continue block6;
                }
                case ALL: {
                    result.add(child);
                    continue block6;
                }
                case NONE: {
                    throw new SpongeException(EventMode.NONE + " mode event should not be present in the event tree");
                }
            }
            throw new SpongeException("Unsupported value: " + eventMode);
        }
        return result;
    }

    @Override
    protected boolean runRuleForNonFinalNode(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        boolean fired = false;
        for (TreeNode<RuleAdapterRuntime.NodeValue> child : this.resolveSubNodesToRun(node)) {
            if (this.runRule(child)) {
                fired = true;
            }
            if (child.getValue() != null) continue;
            node.removeChild(child);
        }
        return fired;
    }

    @Override
    protected int getEventIndex(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        return node.getValue().getIndex();
    }

    @Override
    protected EventMode getEventMode(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        if (node.getValue().getIndex() == null) {
            int index = this.getExpectedEventIndex(node, node.getValue().getEvent());
            if (index >= 0) {
                node.getValue().setIndex(index);
            } else {
                return null;
            }
        }
        return this.getMeta().getEventSpec(this.getEventIndex(node)).getMode();
    }

    @Override
    protected boolean isLeafLevel(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        if (this.getMeta().hasDuration() && !this.adapter.isDurationTriggered()) {
            return node.getLevel() == this.adapter.getEventCount() - 1;
        }
        return node.getLevel() == this.adapter.getEventCount() - 1 - this.noneModeEventAliases.size();
    }

    @Override
    protected void prepareEventAliasMap(TreeNode<RuleAdapterRuntime.NodeValue> node) {
        this.eventAliasMap.clear();
        this.eventTree.getPath(node).forEach(n -> this.eventAliasMap.put(this.getMeta().getEventSpec(this.getEventIndex((TreeNode<RuleAdapterRuntime.NodeValue>)n)).getAlias(), ((RuleAdapterRuntime.NodeValue)n.getValue()).getEvent()));
        this.noneModeEventAliases.forEach(alias -> {
            Event cfr_ignored_0 = this.eventAliasMap.put(alias, null);
        });
    }

    @Override
    public void validate() {
    }
}

