/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util.process;

import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.core.util.process.ProcessInstanceRuntime;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.openksavi.sponge.util.process.ProcessInstance;

public class DefaultProcessInstance
implements ProcessInstance {
    private ProcessInstanceRuntime runtime;
    private Process internalProcess;
    private String outputString;
    private byte[] outputBinary;
    private String errorString;
    private Instant startTime;
    private boolean waitSecondsTimedOut = false;

    public DefaultProcessInstance(SpongeEngine engine, ProcessConfiguration configuration) {
        this.runtime = new ProcessInstanceRuntime(engine, configuration, this);
    }

    public ProcessInstance run() throws InterruptedException {
        Validate.isTrue((this.internalProcess == null ? 1 : 0) != 0, (String)"The process has already started", (Object[])new Object[0]);
        this.runtime.start();
        this.runtime.waitFor();
        return this;
    }

    public ProcessInstance runAsync() throws InterruptedException {
        Validate.isTrue((this.internalProcess == null ? 1 : 0) != 0, (String)"The process has already started", (Object[])new Object[0]);
        this.runtime.start();
        return this;
    }

    private void validateStarted() {
        Validate.notNull((Object)this.internalProcess, (String)"The process is not started", (Object[])new Object[0]);
    }

    public Process getInternalProcess() {
        return this.internalProcess;
    }

    public void setInternalProcess(Process internalProcess) {
        this.internalProcess = internalProcess;
    }

    public ProcessConfiguration getConfiguration() {
        return this.runtime.getConfiguration();
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Instant startTime) {
        this.startTime = startTime;
    }

    public boolean isWaitSecondsTimedOut() {
        return this.waitSecondsTimedOut;
    }

    public void setWaitSecondsTimedOut(boolean waitSecondsTimedOut) {
        this.waitSecondsTimedOut = waitSecondsTimedOut;
    }

    public ProcessInstanceRuntime getRuntime() {
        return this.runtime;
    }

    public void waitForReady() throws InterruptedException {
        this.validateStarted();
        this.runtime.waitForReady();
    }

    public int waitFor() throws InterruptedException {
        this.validateStarted();
        return this.runtime.waitFor();
    }

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        this.validateStarted();
        return this.runtime.waitFor(timeout, unit);
    }

    public void destroy() throws InterruptedException {
        if (this.runtime != null) {
            this.runtime.destroy();
        }
    }

    public boolean destroy(long timeout, TimeUnit unit) throws InterruptedException {
        return this.runtime != null ? this.runtime.destroy(timeout, unit) : true;
    }

    public boolean isAlive() {
        this.validateStarted();
        return this.internalProcess.isAlive();
    }

    public int getExitCode() {
        this.validateStarted();
        return this.internalProcess.exitValue();
    }

    public String getOutputString() {
        this.validateStarted();
        return this.outputString;
    }

    public void setOutputString(String outputString) {
        this.outputString = outputString;
    }

    public byte[] getOutputBinary() {
        this.validateStarted();
        return this.outputBinary;
    }

    public void setOutputBinary(byte[] outputBinary) {
        this.outputBinary = outputBinary;
    }

    public String getErrorString() {
        this.validateStarted();
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public OutputStream getInput() {
        this.validateStarted();
        return this.internalProcess.getOutputStream();
    }

    public InputStream getOutput() {
        this.validateStarted();
        return this.internalProcess.getInputStream();
    }

    public InputStream getError() {
        this.validateStarted();
        return this.internalProcess.getErrorStream();
    }
}

