/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util.process;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.core.util.process.DefaultProcessInstance;
import org.openksavi.sponge.core.util.process.InputStreamLineConsumerRunnable;
import org.openksavi.sponge.core.util.process.ProcessUtils;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.util.process.ErrorRedirect;
import org.openksavi.sponge.util.process.InputRedirect;
import org.openksavi.sponge.util.process.OutputRedirect;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInstanceRuntime {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceRuntime.class);
    private Logger processOutputLogger;
    private Logger processErrorLogger;
    private SpongeEngine engine;
    private ProcessConfiguration configuration;
    private DefaultProcessInstance instance;
    private Semaphore semaphore = new Semaphore(0, true);
    private AtomicReference<String> errorLine = new AtomicReference<Object>(null);
    private List<Future<?>> inputStreamLineConsumerRunnableFutures = new ArrayList();
    private ExecutorService executor;
    private AtomicBoolean waitForReadyFinished = new AtomicBoolean(false);

    public ProcessInstanceRuntime(SpongeEngine engine, ProcessConfiguration configuration, DefaultProcessInstance instance) {
        this.engine = engine;
        this.configuration = configuration;
        this.instance = instance;
    }

    public ProcessConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void initState() {
        this.initLoggers();
        this.semaphore.drainPermits();
        this.errorLine.set(null);
        this.inputStreamLineConsumerRunnableFutures.clear();
        this.executor = null;
        this.instance.setStartTime(Instant.now());
    }

    protected void initLoggers() {
        String loggerCode = this.configuration.getName() != null ? this.configuration.getName() : this.configuration.getExecutable();
        this.processOutputLogger = LoggerFactory.getLogger((String)(ProcessInstanceRuntime.class.getPackage().getName() + ".Output." + loggerCode));
        this.processErrorLogger = LoggerFactory.getLogger((String)(ProcessInstanceRuntime.class.getPackage().getName() + ".Error." + loggerCode));
    }

    protected ProcessBuilder createAndConfigureProcessBuilder() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.configuration.getExecutable());
        commands.addAll(this.configuration.getArguments());
        ProcessBuilder builder = new ProcessBuilder(commands);
        if (this.configuration.getProcessBuilderConsumer() != null) {
            this.configuration.getProcessBuilderConsumer().accept(builder);
        }
        if (this.configuration.getInputRedirect() == InputRedirect.INHERIT) {
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        }
        if (this.configuration.getOutputRedirect() == OutputRedirect.INHERIT) {
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        if (this.configuration.getErrorRedirect() == ErrorRedirect.INHERIT) {
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        builder.redirectErrorStream(this.configuration.isRedirectErrorStream());
        if (this.configuration.getWorkingDir() != null) {
            builder.directory(new File(this.configuration.getWorkingDir()));
        }
        builder.environment().putAll(this.configuration.getEnv());
        return builder;
    }

    protected Charset getCharset() {
        return this.configuration.getCharset() != null ? this.configuration.getCharset() : Charset.defaultCharset();
    }

    protected BiConsumer<Logger, String> getOutputLoggingConsumer() {
        return this.configuration.getOutputLoggingConsumer() != null ? this.configuration.getOutputLoggingConsumer() : (lineLogger, line) -> lineLogger.info(line);
    }

    protected BiConsumer<Logger, String> getErrorLoggingConsumer() {
        return this.configuration.getErrorLoggingConsumer() != null ? this.configuration.getErrorLoggingConsumer() : (lineLogger, line) -> lineLogger.warn(line);
    }

    protected InputStreamLineConsumerRunnable createInputStreamLineConsumerRunnable(InputStream inputStream, Consumer<String> consumer, Logger lineLogger, BiConsumer<Logger, String> loggingConsumer) {
        return new InputStreamLineConsumerRunnable(inputStream, line -> {
            loggingConsumer.accept(lineLogger, (String)line);
            if (consumer != null) {
                consumer.accept((String)line);
            }
            if (this.configuration.getWaitForPositiveLineRegexp() != null && line.matches(this.configuration.getWaitForPositiveLineRegexp())) {
                this.semaphore.release(this.getRequiredFullSemaphorePermits());
            } else if (this.configuration.getWaitForNegativeLineRegexp() != null && line.matches(this.configuration.getWaitForNegativeLineRegexp())) {
                this.errorLine.set((String)line);
                this.semaphore.release(this.getRequiredFullSemaphorePermits());
            }
        }, () -> this.semaphore.release(), this.getCharset());
    }

    protected int getRequiredFullSemaphorePermits() {
        return this.inputStreamLineConsumerRunnableFutures.size();
    }

    protected void optionallySetOutputConsumers() {
        ArrayList<InputStreamLineConsumerRunnable> runnables = new ArrayList<InputStreamLineConsumerRunnable>();
        if (this.configuration.getOutputRedirect() == OutputRedirect.CONSUMER) {
            runnables.add(this.createInputStreamLineConsumerRunnable(this.instance.getInternalProcess().getInputStream(), this.configuration.getOutputLineConsumer(), this.processOutputLogger, this.getOutputLoggingConsumer()));
        }
        if (this.configuration.getErrorRedirect() == ErrorRedirect.CONSUMER) {
            runnables.add(this.createInputStreamLineConsumerRunnable(this.instance.getInternalProcess().getErrorStream(), this.configuration.getErrorLineConsumer(), this.processErrorLogger, this.getErrorLoggingConsumer()));
        }
        if (!runnables.isEmpty()) {
            this.executor = Executors.newFixedThreadPool(runnables.size());
            runnables.forEach(runnable -> this.inputStreamLineConsumerRunnableFutures.add(this.executor.submit((Runnable)runnable)));
        }
    }

    protected void optionallyWaitForOutputLine() throws InterruptedException {
        if (ProcessUtils.shouldWaitForSpecificLine(this.configuration)) {
            if (this.configuration.getWaitForLineTimeout() == null) {
                this.semaphore.acquire(this.getRequiredFullSemaphorePermits());
            } else {
                Validate.isTrue((boolean)this.semaphore.tryAcquire(this.getRequiredFullSemaphorePermits(), this.configuration.getWaitForLineTimeout(), TimeUnit.SECONDS), (String)"Process wait timeout exceeded", (Object[])new Object[0]);
            }
            if (this.errorLine.get() != null) {
                if (this.instance.getInternalProcess().isAlive()) {
                    this.instance.getInternalProcess().destroy();
                }
                throw new SpongeException("Error in the subprocess: " + this.errorLine.get());
            }
        }
    }

    protected String readErrorStream() throws IOException {
        String errorsString = IOUtils.readLines((InputStream)this.instance.getInternalProcess().getErrorStream(), (Charset)this.getCharset()).stream().collect(Collectors.joining("\n")).trim();
        return errorsString.isEmpty() ? null : errorsString;
    }

    protected void optionallySetOutputData() {
        try {
            switch (this.configuration.getOutputRedirect()) {
                case STRING: {
                    this.instance.setOutputString(IOUtils.readLines((InputStream)this.instance.getInternalProcess().getInputStream(), (Charset)this.getCharset()).stream().collect(Collectors.joining("\n")));
                    break;
                }
                case BINARY: {
                    this.instance.setOutputBinary(IOUtils.toByteArray((InputStream)this.instance.getInternalProcess().getInputStream()));
                    break;
                }
                case FILE: {
                    FileUtils.copyInputStreamToFile((InputStream)this.instance.getInternalProcess().getInputStream(), (File)new File(this.configuration.getOutputFile()));
                    break;
                }
            }
            switch (this.configuration.getErrorRedirect()) {
                case STRING: {
                    this.instance.setErrorString(this.readErrorStream());
                    break;
                }
                case EXCEPTION: {
                    String errorString = this.readErrorStream();
                    if (errorString == null) break;
                    throw new SpongeException(this.getName() + " error: " + errorString);
                }
                case FILE: {
                    FileUtils.copyInputStreamToFile((InputStream)this.instance.getInternalProcess().getErrorStream(), (File)new File(this.configuration.getErrorFile()));
                    break;
                }
            }
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
        }
    }

    protected String getName() {
        return this.configuration.getName() != null ? this.configuration.getName() : this.configuration.getExecutable();
    }

    protected void optionallySetInputData() {
        try {
            switch (this.configuration.getInputRedirect()) {
                case STRING: {
                    IOUtils.write((String)this.configuration.getInputString(), (OutputStream)this.instance.getInput(), (Charset)this.getCharset());
                    this.instance.getInput().close();
                    break;
                }
                case BINARY: {
                    IOUtils.write((byte[])this.configuration.getInputBinary(), (OutputStream)this.instance.getInput());
                    this.instance.getInput().close();
                    break;
                }
                case FILE: {
                    FileUtils.copyFile((File)new File(this.configuration.getInputFile()), (OutputStream)this.instance.getInput());
                    this.instance.getInput().close();
                    break;
                }
            }
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
        }
    }

    protected void optionallyWaitForTheProcessToEnd() throws InterruptedException {
        long elapsedSeconds = Duration.between(this.instance.getStartTime(), Instant.now()).getSeconds();
        if (this.configuration.getWaitSeconds() != null) {
            if (this.configuration.getWaitSeconds() > elapsedSeconds) {
                this.instance.setWaitSecondsTimedOut(!this.instance.getInternalProcess().waitFor(this.configuration.getWaitSeconds() - elapsedSeconds, TimeUnit.SECONDS));
            }
        } else if (ProcessUtils.isRedirectSavingInstantly(this.configuration)) {
            this.instance.getInternalProcess().waitFor();
        }
    }

    protected String getArgsString() {
        return this.configuration.getArguments().stream().map(arg -> StringUtils.containsWhitespace((CharSequence)arg) ? String.format("\"%s\"", arg) : arg).collect(Collectors.joining(" "));
    }

    protected void startProcess(ProcessBuilder builder) {
        logger.debug("Running a new subprocess: {} {}", (Object)this.configuration.getExecutable(), (Object)this.getArgsString());
        if (!this.configuration.getEnv().isEmpty()) {
            logger.trace("The subprocess additional environment: {}", (Object)this.configuration.getEnv());
        }
        try {
            this.instance.setInternalProcess(builder.start());
        }
        catch (IOException e) {
            throw SpongeUtils.wrapException(this.getName(), (Throwable)e);
        }
    }

    public void start() throws InterruptedException {
        ProcessUtils.validateProcessConfiguration(this.configuration);
        this.initState();
        this.startProcess(this.createAndConfigureProcessBuilder());
        this.optionallySetOutputConsumers();
        if (ProcessUtils.shouldWaitForReadyInstantly(this.configuration)) {
            this.waitForReady();
        }
    }

    protected void optionallyValidateExitCode() {
        if (this.configuration.isExceptionOnExitCode() && !this.instance.isAlive() && this.instance.getExitCode() != 0) {
            throw new SpongeException("The subprocess exit code is " + this.instance.getExitCode());
        }
    }

    public void waitForReady() throws InterruptedException {
        if (this.waitForReadyFinished.get()) {
            return;
        }
        this.optionallySetInputData();
        this.optionallyWaitForOutputLine();
        this.optionallySetOutputData();
        this.optionallyWaitForTheProcessToEnd();
        this.waitForReadyFinished.set(true);
        this.optionallyValidateExitCode();
    }

    public int waitFor() throws InterruptedException {
        this.waitForReady();
        int exitCode = this.instance.getInternalProcess().waitFor();
        this.optionallyValidateExitCode();
        return exitCode;
    }

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        this.waitForReady();
        boolean exited = this.instance.getInternalProcess().waitFor(timeout, unit);
        if (exited) {
            this.optionallyValidateExitCode();
        }
        return exited;
    }

    public void destroy() throws InterruptedException {
        this.instance.getInternalProcess().destroyForcibly().waitFor();
        this.cleanupDestroyed();
    }

    public boolean destroy(long timeout, TimeUnit unit) throws InterruptedException {
        boolean exited = this.instance.getInternalProcess().destroyForcibly().waitFor(timeout, unit);
        if (exited) {
            this.cleanupDestroyed();
        }
        return exited;
    }

    protected void cleanupDestroyed() {
        this.inputStreamLineConsumerRunnableFutures.forEach(future -> future.cancel(true));
        if (this.executor != null) {
            SpongeUtils.shutdownExecutorService(this.engine, "ProcessInstanceRuntime", this.executor);
        }
    }
}

