/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.util.process;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.config.Configuration;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.util.process.ErrorRedirect;
import org.openksavi.sponge.util.process.InputRedirect;
import org.openksavi.sponge.util.process.OutputRedirect;
import org.openksavi.sponge.util.process.ProcessConfiguration;
import org.openksavi.sponge.util.process.ProcessInstanceBuilder;

public abstract class ProcessUtils {
    public static final String TAG_PROCESS_EXECUTABLE = "executable";
    public static final String TAG_PROCESS_ARGUMENT = "argument";
    public static final String TAG_PROCESS_WORKING_DIR = "workingDir";
    public static final String TAG_PROCESS_ENV = "env";
    public static final String TAG_PROCESS_WAIT_SECONDS = "waitSeconds";
    public static final String TAG_PROCESS_INPUT_REDIRECT = "inputRedirect";
    public static final String TAG_PROCESS_OUTPUT_REDIRECT = "outputRedirect";
    public static final String TAG_PROCESS_ERROR_REDIRECT = "errorRedirect";
    public static final String TAG_PROCESS_CHARSET = "charset";
    public static final String TAG_PROCESS_WAIT_FOR_POSITIVE_LINE_REGEXP = "waitForPositiveLineRegexp";
    public static final String TAG_PROCESS_WAIT_FOR_NEGATIVE_LINE_REGEXP = "waitForNegativeLineRegexp";
    public static final String TAG_PROCESS_WAIT_FOR_LINE_TIMEOUT = "waitForLineTimeout";
    public static final String TAG_PROCESS_INPUT_STRING = "inputString";
    public static final String TAG_PROCESS_INPUT_BINARY = "inputBinary";
    public static final String ATTR_PROCESS_ENV_NAME = "name";

    private ProcessUtils() {
    }

    public static ProcessInstanceBuilder createProcessInstanceBuilder(SpongeEngine engine, Configuration configuration) {
        String inputBinaryString;
        String inputStringString;
        String charsetString;
        String errorRedirectString;
        String outputRedirectString;
        LinkedHashMap env = new LinkedHashMap();
        configuration.getConfigurationsAt(TAG_PROCESS_ENV).forEach(c -> env.put(Validate.notNull((Object)c.getAttribute(ATTR_PROCESS_ENV_NAME, null), (String)"The environment variable must have a name", (Object[])new Object[0]), c.getValue()));
        ProcessInstanceBuilder builder = new ProcessInstanceBuilder(engine, configuration.getString(TAG_PROCESS_EXECUTABLE, null)).arguments(configuration.getConfigurationsAt(TAG_PROCESS_ARGUMENT).stream().map(Configuration::getValue).collect(Collectors.toList())).workingDir(configuration.getString(TAG_PROCESS_WORKING_DIR, null)).env(env).waitSeconds(configuration.getLong(TAG_PROCESS_WAIT_SECONDS, null));
        String inputRedirectString = configuration.getString(TAG_PROCESS_INPUT_REDIRECT, null);
        if (inputRedirectString != null) {
            builder.inputRedirect(InputRedirect.valueOf((String)inputRedirectString));
        }
        if ((outputRedirectString = configuration.getString(TAG_PROCESS_OUTPUT_REDIRECT, null)) != null) {
            builder.outputRedirect(OutputRedirect.valueOf((String)outputRedirectString));
        }
        if ((errorRedirectString = configuration.getString(TAG_PROCESS_ERROR_REDIRECT, null)) != null) {
            builder.errorRedirect(ErrorRedirect.valueOf((String)errorRedirectString));
        }
        if ((charsetString = configuration.getString(TAG_PROCESS_CHARSET, null)) != null) {
            builder.charset(Charset.forName(charsetString));
        }
        if ((inputStringString = configuration.getString(TAG_PROCESS_INPUT_STRING, null)) != null) {
            builder.inputAsString(inputStringString);
        }
        if ((inputBinaryString = configuration.getString(TAG_PROCESS_INPUT_BINARY, null)) != null) {
            builder.inputAsBinary(Base64.getDecoder().decode(inputBinaryString.getBytes(StandardCharsets.UTF_8)));
        }
        builder.waitForPositiveLineRegexp(configuration.getString(TAG_PROCESS_WAIT_FOR_POSITIVE_LINE_REGEXP, null)).waitForNegativeLineRegexp(configuration.getString(TAG_PROCESS_WAIT_FOR_NEGATIVE_LINE_REGEXP, null)).waitForLineTimeout(configuration.getLong(TAG_PROCESS_WAIT_FOR_LINE_TIMEOUT, null));
        return builder;
    }

    public static boolean isOutputRedirectSavingInstantly(ProcessConfiguration configuration) {
        return configuration.getOutputRedirect() == OutputRedirect.STRING || configuration.getOutputRedirect() == OutputRedirect.BINARY || configuration.getOutputRedirect() == OutputRedirect.FILE;
    }

    public static boolean isErrorRedirectSavingInstantly(ProcessConfiguration configuration) {
        return configuration.getErrorRedirect() == ErrorRedirect.STRING || configuration.getErrorRedirect() == ErrorRedirect.FILE;
    }

    public static boolean isRedirectSavingInstantly(ProcessConfiguration configuration) {
        return ProcessUtils.isOutputRedirectSavingInstantly(configuration) || ProcessUtils.isErrorRedirectSavingInstantly(configuration);
    }

    public static void validateProcessConfiguration(ProcessConfiguration configuration) {
        Validate.isTrue((configuration.getOutputLineConsumer() == null || configuration.getOutputRedirect() == OutputRedirect.CONSUMER ? 1 : 0) != 0, (String)"If the output line consumer is provided, the output redirect type must be CONSUMER", (Object[])new Object[0]);
        Validate.isTrue((configuration.getErrorLineConsumer() == null || configuration.getErrorRedirect() == ErrorRedirect.CONSUMER ? 1 : 0) != 0, (String)"If the error line consumer is provided, the error redirect type must be CONSUMER", (Object[])new Object[0]);
        Validate.isTrue((!ProcessUtils.shouldWaitForSpecificLine(configuration) || configuration.getOutputRedirect() == OutputRedirect.CONSUMER || configuration.getErrorRedirect() == ErrorRedirect.CONSUMER ? 1 : 0) != 0, (String)"If the waiting for a specific line is set, the output or error redirect type must be CONSUMER", (Object[])new Object[0]);
        Validate.isTrue((configuration.getInputRedirect() != InputRedirect.STRING || configuration.getInputString() != null ? 1 : 0) != 0, (String)"The input string must be set if the input redirect is STRING", (Object[])new Object[0]);
        Validate.isTrue((configuration.getInputRedirect() != InputRedirect.BINARY || configuration.getInputBinary() != null ? 1 : 0) != 0, (String)"The input binary must be set if the input redirect is BINARY", (Object[])new Object[0]);
        Validate.isTrue((configuration.getInputRedirect() != InputRedirect.FILE || configuration.getInputFile() != null ? 1 : 0) != 0, (String)"The input file must be set if the input redirect is FILE", (Object[])new Object[0]);
        Validate.isTrue((configuration.getOutputRedirect() != OutputRedirect.FILE || configuration.getOutputFile() != null ? 1 : 0) != 0, (String)"The output file must be set if the output redirect is FILE", (Object[])new Object[0]);
        Validate.isTrue((configuration.getErrorRedirect() != ErrorRedirect.FILE || configuration.getErrorFile() != null ? 1 : 0) != 0, (String)"The error file must be set if the error redirect is FILE", (Object[])new Object[0]);
    }

    public static boolean shouldWaitForReadyInstantly(ProcessConfiguration configuration) {
        return configuration.getInputRedirect() != InputRedirect.STREAM;
    }

    public static boolean shouldWaitForSpecificLine(ProcessConfiguration configuration) {
        return configuration.getWaitForPositiveLineRegexp() != null || configuration.getWaitForNegativeLineRegexp() != null;
    }
}

