/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.java.core;

import org.openksavi.sponge.Processor;
import org.openksavi.sponge.SpongeException;
import org.openksavi.sponge.core.engine.BaseSpongeEngine;
import org.openksavi.sponge.core.engine.DefaultProcessorInstanceHolder;
import org.openksavi.sponge.core.kb.BaseNonScriptKnowledgeBaseInterpreter;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ProcessorInstanceHolder;
import org.openksavi.sponge.engine.SpongeEngine;
import org.openksavi.sponge.java.core.JavaConstants;
import org.openksavi.sponge.java.core.JavaKnowledgeBaseEngineOperations;
import org.openksavi.sponge.java.core.JavaUtils;
import org.openksavi.sponge.kb.KnowledgeBase;

public class JavaKnowledgeBaseInterpreter
extends BaseNonScriptKnowledgeBaseInterpreter {
    public JavaKnowledgeBaseInterpreter(SpongeEngine engine, KnowledgeBase knowledgeBase) {
        super(new JavaKnowledgeBaseEngineOperations((BaseSpongeEngine)engine, knowledgeBase), JavaConstants.TYPE);
    }

    public Object invokeMethod(Object target, String name, Object ... args) {
        return SpongeUtils.invokeMethod(target, name, args);
    }

    @Override
    protected <T> T doCreateInstance(String className, Class<T> javaClass) {
        return SpongeUtils.createInstance(className, javaClass);
    }

    public ProcessorInstanceHolder createProcessorInstanceByProcessorClass(KnowledgeBase knowledgeBase, Object processorClass, Class<?> javaClass) {
        if (processorClass instanceof Class) {
            Class destJavaClass = (Class)processorClass;
            if (!javaClass.isAssignableFrom(destJavaClass)) {
                throw new SpongeException("Unsupported processor specification: " + destJavaClass.getName() + " can't be used as " + javaClass.getName());
            }
            try {
                return new DefaultProcessorInstanceHolder((Processor)destJavaClass.newInstance(), JavaUtils.createProcessorName(destJavaClass), true);
            }
            catch (Throwable e) {
                throw SpongeUtils.wrapException(destJavaClass.getName(), knowledgeBase.getInterpreter(), e);
            }
        }
        return null;
    }
}

