/*
 * Decompiled with CFR 0.152.
 */
package org.openksavi.sponge.core.action;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.openksavi.sponge.action.Action;
import org.openksavi.sponge.action.ActionAdapter;
import org.openksavi.sponge.action.ActionMeta;
import org.openksavi.sponge.action.IsActionActiveContext;
import org.openksavi.sponge.action.ProvideArgsContext;
import org.openksavi.sponge.action.ProvideArgsParameters;
import org.openksavi.sponge.core.BaseProcessorAdapter;
import org.openksavi.sponge.core.action.BaseActionDefinition;
import org.openksavi.sponge.core.action.BaseActionMeta;
import org.openksavi.sponge.core.util.SpongeUtils;
import org.openksavi.sponge.engine.ProcessorType;
import org.openksavi.sponge.type.DataType;
import org.openksavi.sponge.type.DataTypeKind;
import org.openksavi.sponge.type.provided.ProvidedValue;
import org.openksavi.sponge.util.DataTypeUtils;
import org.openksavi.sponge.util.SpongeApiUtils;

public class BaseActionAdapter
extends BaseProcessorAdapter<Action>
implements ActionAdapter {
    private Set<String> registeredTypeNames = new LinkedHashSet<String>();

    public BaseActionAdapter(BaseActionDefinition definition) {
        super(definition);
    }

    public ProcessorType getType() {
        return ProcessorType.ACTION;
    }

    @Override
    public BaseActionDefinition getDefinition() {
        return (BaseActionDefinition)super.getDefinition();
    }

    @Override
    public BaseActionMeta getMeta() {
        return (BaseActionMeta)super.getMeta();
    }

    protected Set<String> buildProvideArgsNames(ProvideArgsParameters parameters) {
        LinkedHashSet<String> finalNames = new LinkedHashSet<String>();
        if (parameters.getProvide() != null) {
            for (String name : parameters.getProvide()) {
                Validate.isTrue((boolean)BaseActionAdapter.isArgProvided(this.resolveDataType(name, parameters)), (String)"Argument '%s' is not defined as provided", (Object[])new Object[]{name});
                finalNames.add(name);
            }
        }
        return finalNames;
    }

    protected DataType resolveDataType(String argName, ProvideArgsParameters parameters) {
        return parameters.getDynamicTypes() != null && parameters.getDynamicTypes().containsKey(argName) ? (DataType)parameters.getDynamicTypes().get(argName) : this.getMeta().getArg(argName);
    }

    protected Set<String> buildSubmitArgsNames(ProvideArgsParameters parameters) {
        LinkedHashSet<String> finalSubmitted = new LinkedHashSet<String>();
        if (parameters.getSubmit() != null) {
            for (String name : parameters.getSubmit()) {
                Validate.isTrue((boolean)BaseActionAdapter.isArgSubmittable(this.resolveDataType(name, parameters)), (String)"Argument '%s' is not defined as submittable", (Object[])new Object[]{name});
                finalSubmitted.add(name);
            }
        }
        return finalSubmitted;
    }

    protected Map<String, Object> buildCurrentArgs(ProvideArgsParameters parameters) {
        return parameters.getCurrent() != null ? parameters.getCurrent() : Collections.emptyMap();
    }

    public boolean isActive(IsActionActiveContext context) {
        if (!this.getMeta().isActivatable()) {
            return true;
        }
        IsActionActiveContext contextCopy = context.clone();
        if (contextCopy.getFeatures() == null) {
            contextCopy.setFeatures(new LinkedHashMap());
        }
        return ((Action)this.getProcessor()).onIsActive(contextCopy);
    }

    public Map<String, ProvidedValue<?>> provideArgs(ProvideArgsParameters parameters) {
        Validate.notNull(this.getMeta().getArgs(), (String)"Arguments not defined", (Object[])new Object[0]);
        LinkedHashMap effectiveArgFeatures = new LinkedHashMap();
        if (parameters.getArgFeatures() != null) {
            effectiveArgFeatures.putAll(parameters.getArgFeatures());
        }
        Map efefctiveDynamicTypes = parameters.getDynamicTypes() != null ? parameters.getDynamicTypes() : Collections.emptyMap();
        Set<String> provideSet = this.buildProvideArgsNames(parameters);
        Set<String> submitSet = this.buildSubmitArgsNames(parameters);
        provideSet.forEach(name -> {
            Map cfr_ignored_0 = effectiveArgFeatures.putIfAbsent(name, new LinkedHashMap());
        });
        submitSet.forEach(name -> {
            Map cfr_ignored_0 = effectiveArgFeatures.putIfAbsent(name, new LinkedHashMap());
        });
        LinkedHashMap provided = new LinkedHashMap();
        ((Action)this.getProcessor()).onProvideArgs(new ProvideArgsContext(provideSet, submitSet, this.buildCurrentArgs(parameters), provided, efefctiveDynamicTypes, effectiveArgFeatures, parameters.isInitial().booleanValue()));
        provided.keySet().forEach(providedArg -> Validate.isTrue((this.resolveDataType((String)providedArg, parameters).getProvided() != null ? 1 : 0) != 0, (String)"The argument '%s' that has been provided is not configured as provided", (Object[])new Object[]{providedArg}));
        return provided;
    }

    @Override
    public void validate() {
        super.validate();
        Validate.isTrue((this.getMeta().getArgs() != null && this.getMeta().getResult() != null || this.getMeta().getArgs() == null && this.getMeta().getResult() == null ? 1 : 0) != 0, (String)"Both argument types and result type must be set or not", (Object[])new Object[0]);
        if (this.getMeta().getArgs() != null) {
            boolean foundFirstOptionalArg = false;
            for (DataType argType : this.getMeta().getArgs()) {
                this.validateArg(argType);
                Validate.isTrue((!foundFirstOptionalArg || argType.isOptional() ? 1 : 0) != 0, (String)"Only trailing arguments may be optional", (Object[])new Object[0]);
                if (!argType.isOptional()) continue;
                foundFirstOptionalArg = true;
            }
            this.validateArgProvided();
            this.validateInputStreamArgs();
        }
        this.validateResult(this.getMeta().getResult());
        this.mergeInheritedTypes();
        this.registeredTypeNames = this.calculateRegisteredTypeNames();
    }

    private void validateArg(DataType argType) {
        Validate.notNull((Object)argType, (String)"Null argument type in the '%s' action", (Object[])new Object[]{this.getMeta().getName()});
        Validate.notNull((Object)argType.getName(), (String)"Argument has no name", (Object[])new Object[0]);
        SpongeUtils.validateType(argType, String.format("argument '%s'", argType.getName()));
    }

    private void validateArgProvided() {
        Map fullArgTypesMap = SpongeApiUtils.createNamedActionArgTypesMapRecursively((ActionMeta)this.getMeta());
        SpongeApiUtils.traverseActionArguments((ActionMeta)this.getMeta(), qualifiedType -> {
            DataType type = qualifiedType.getType();
            if (qualifiedType.getPath() != null) {
                if (type.getProvided() != null) {
                    type.getProvided().getDependencies().forEach(dependency -> Validate.isTrue((boolean)fullArgTypesMap.containsKey(dependency), (String)"The argument '%s' depends on an argument '%s' that is not defined or is not allowed", (Object[])new Object[]{qualifiedType.getPath(), dependency}));
                }
            } else {
                Validate.isTrue((type.getProvided() == null ? 1 : 0) != 0, (String)"The %s argument is set as provided but doesn't have a complete name path", (Object[])new Object[]{type.getKind().name()});
            }
        }, (boolean)false);
    }

    private void validateInputStreamArgs() {
        if (this.getMeta().getArgs() != null) {
            boolean foundFirstInputStreamArg = false;
            for (DataType argType : this.getMeta().getArgs()) {
                Validate.isTrue((!foundFirstInputStreamArg || argType.getKind() == DataTypeKind.INPUT_STREAM ? 1 : 0) != 0, (String)"Only trailing arguments may be of type InputStreamType", (Object[])new Object[0]);
                if (argType.getKind() != DataTypeKind.INPUT_STREAM) continue;
                foundFirstInputStreamArg = true;
            }
        }
    }

    private static boolean isArgProvided(DataType argType) {
        return argType.getProvided() != null;
    }

    private static boolean isArgSubmittable(DataType argType) {
        return argType.getProvided() != null && argType.getProvided().getSubmittable() != null;
    }

    private void validateResult(DataType resultType) {
        if (resultType != null) {
            String errorSource = String.format("result of the action '%s'", this.getMeta().getName());
            SpongeUtils.validateType(resultType, errorSource);
        }
    }

    public Set<String> getRegisteredTypeNames() {
        return this.registeredTypeNames;
    }

    protected Set<String> calculateRegisteredTypeNames() {
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
        if (this.getMeta().getArgs() != null) {
            this.getMeta().getArgs().forEach(type -> typeNames.addAll(DataTypeUtils.getRegisteredTypeNames((DataType)type)));
        }
        if (this.getMeta().getResult() != null) {
            typeNames.addAll(DataTypeUtils.getRegisteredTypeNames((DataType)this.getMeta().getResult()));
        }
        return typeNames;
    }

    protected void mergeInheritedTypes() {
        if (this.getMeta().getArgs() != null) {
            this.getMeta().getArgs().forEach(SpongeUtils::setupType);
        }
        if (this.getMeta().getResult() != null) {
            SpongeUtils.setupType(this.getMeta().getResult());
        }
    }
}

